/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.fly;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.storage.IStorage;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.zutils.utils.TimerBuilder;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import java.util.UUID;
import java.util.stream.Stream;

public class CommandFlyAdd
extends VCommand {
    public CommandFlyAdd(EssentialsPlugin plugin) {
        super(plugin);
        this.addSubCommand("add");
        this.setPermission(Permission.ESSENTIALS_FLY_ADD);
        this.setDescription(Message.DESCRIPTION_FLY_ADD);
        this.addRequireOfflinePlayerNameArg();
        this.addRequireArg("seconds", (a, b) -> Stream.of(10, 20, 30, 40, 50, 60, 70, 80, 90).map(String::valueOf).toList());
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        String userName = this.argAsString(0);
        long seconds = this.argAsLong(1);
        this.fetchUniqueId(userName, uniqueId -> {
            long flySeconds;
            IStorage storage = plugin.getStorageManager().getStorage();
            User user = plugin.getUser((UUID)uniqueId);
            long l = flySeconds = user == null ? storage.getFlySeconds((UUID)uniqueId) : user.getFlySeconds();
            if (user == null) {
                storage.upsertFlySeconds((UUID)uniqueId, flySeconds += seconds);
            } else {
                user.addFlySeconds(seconds);
            }
            this.message(this.sender, Message.COMMAND_FLY_ADD, "%player%", userName, "%time%", TimerBuilder.getStringTime(seconds * 1000L));
        });
        return CommandResultType.SUCCESS;
    }
}

