/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.hologram.text;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.hologram.Hologram;
import fr.maxlego08.essentials.api.hologram.HologramManager;
import fr.maxlego08.essentials.api.hologram.HologramType;
import fr.maxlego08.essentials.api.hologram.configuration.TextHologramConfiguration;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.commands.commands.hologram.VCommandHologram;
import java.util.ArrayList;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class CommandHologramBackground
extends VCommandHologram {
    public CommandHologramBackground(EssentialsPlugin plugin) {
        super(plugin, HologramType.TEXT);
        this.setPermission(Permission.ESSENTIALS_HOLOGRAM_TEXT_BACKGROUND);
        this.setDescription(Message.DESCRIPTION_HOLOGRAM_TEXT_BACKGROUND);
        this.addSubCommand("background");
        this.addRequireArg("background", (a, b) -> {
            ArrayList<String> colors = new ArrayList<String>(NamedTextColor.NAMES.keys());
            colors.add("reset");
            colors.add("default");
            colors.add("transparent");
            return colors;
        });
    }

    @Override
    protected void perform(EssentialsPlugin plugin, Hologram hologram, HologramManager manager) {
        TextColor background;
        String color = this.argAsString(1);
        if ("reset".equals(color) || "default".equals(color)) {
            background = null;
        } else {
            background = "transparent".equals(color) ? Hologram.TRANSPARENT : (color.startsWith("#") ? TextColor.fromHexString((String)color) : (TextColor)NamedTextColor.NAMES.value((Object)color.replace(' ', '_')));
            if (background == null) {
                this.message(this.sender, Message.HOLOGRAM_TEXT_BACKGROUND_ERROR, new Object[0]);
                return;
            }
        }
        ((TextHologramConfiguration)hologram.getConfiguration()).setBackground(background);
        hologram.update();
        hologram.updateForAllPlayers();
        manager.saveHologram(hologram);
        this.message(this.sender, Message.HOLOGRAM_TEXT_BACKGROUND, "%name%", hologram.getName(), "%color%", color);
    }
}

