/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.items;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.module.modules.ItemModule;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import java.util.ArrayList;
import java.util.Arrays;
import org.bukkit.entity.Player;

public class CommandGive
extends VCommand {
    public CommandGive(EssentialsPlugin plugin) {
        super(plugin);
        this.setModule(ItemModule.class);
        this.setPermission(Permission.ESSENTIALS_GIVE);
        this.setDescription(Message.DESCRIPTION_GIVE);
        this.addRequirePlayerNameArg();
        this.addRequireArg("item", (sender, args) -> {
            ArrayList<String> materials = new ArrayList<String>(plugin.getMaterials().stream().map(Enum::name).map(String::toLowerCase).toList());
            materials.addAll(plugin.getModuleManager().getModule(ItemModule.class).getItemsName());
            return materials;
        });
        this.addOptionalArg("amount", (sender, args) -> Arrays.asList("1", "64", "full"));
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        Player player = this.argAsPlayer(0);
        String itemName = this.argAsString(1);
        String amount = this.argAsString(2, "1");
        ItemModule module = plugin.getModuleManager().getModule(ItemModule.class);
        if (amount.equalsIgnoreCase("full")) {
            module.giveFullInventory(this.sender, player, itemName);
        } else {
            int amountInteger = this.argAsInteger(2, 1);
            module.give(this.sender, player, itemName, amountInteger);
        }
        return CommandResultType.SUCCESS;
    }
}

