/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.items;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.module.modules.ItemModule;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import fr.maxlego08.essentials.zutils.utils.paper.PaperComponent;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CommandItemLoreAdd
extends VCommand {
    private final NamespacedKey loreLineRaw;

    public CommandItemLoreAdd(EssentialsPlugin plugin) {
        super(plugin);
        this.loreLineRaw = new NamespacedKey((Plugin)plugin, "lore-line-raw");
        this.setModule(ItemModule.class);
        this.setPermission(Permission.ESSENTIALS_ITEM_LORE_ADD);
        this.setDescription(Message.DESCRIPTION_ITEM_LORE_ADD);
        this.addSubCommand("add");
        this.addRequireArg("line");
        this.setExtendedArgs(true);
        this.onlyPlayers();
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        ArrayList<Component> components;
        String loreLine = this.getArgs(1);
        if (loreLine.isEmpty()) {
            return CommandResultType.SYNTAX_ERROR;
        }
        ItemStack itemStack = this.player.getInventory().getItemInMainHand();
        if (itemStack.getType().isAir()) {
            this.message(this.sender, Message.COMMAND_ITEM_EMPTY, new Object[0]);
            return CommandResultType.DEFAULT;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        ArrayList<Object> arrayList = components = itemMeta.hasLore() ? itemMeta.lore() : new ArrayList();
        if (components == null) {
            components = new ArrayList<Component>();
        }
        PaperComponent paperComponent = (PaperComponent)this.componentMessage;
        components.add(paperComponent.getComponent(loreLine).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE));
        itemMeta.lore(components);
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        String[] rawLoreLines = dataContainer.has(this.loreLineRaw, PersistentDataType.STRING) ? ((String)dataContainer.getOrDefault(this.loreLineRaw, PersistentDataType.STRING, (Object)"")).split(";") : new String[]{};
        CharSequence[] newRawLoreLines = new String[rawLoreLines.length + 1];
        System.arraycopy(rawLoreLines, 0, newRawLoreLines, 0, rawLoreLines.length);
        newRawLoreLines[newRawLoreLines.length - 1] = loreLine;
        String rawLoreCombined = String.join((CharSequence)";", newRawLoreLines);
        dataContainer.set(this.loreLineRaw, PersistentDataType.STRING, (Object)rawLoreCombined);
        itemStack.setItemMeta(itemMeta);
        this.message(this.sender, Message.COMMAND_ITEM_LORE_ADD, "%text%", loreLine);
        return CommandResultType.SUCCESS;
    }
}

