/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.items;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.module.modules.ItemModule;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import fr.maxlego08.essentials.zutils.utils.paper.PaperComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CommandItemLoreSet
extends VCommand {
    private final NamespacedKey loreLineRaw;

    public CommandItemLoreSet(EssentialsPlugin plugin) {
        super(plugin);
        this.loreLineRaw = new NamespacedKey((Plugin)plugin, "lore-line-raw");
        this.setModule(ItemModule.class);
        this.setPermission(Permission.ESSENTIALS_ITEM_LORE_SET);
        this.setDescription(Message.DESCRIPTION_ITEM_LORE_SET);
        this.addSubCommand("set");
        this.addRequireArg("index", (sender, args) -> {
            Player player;
            ItemStack itemStack;
            ItemMeta itemMeta;
            if (sender instanceof Player && (itemMeta = (itemStack = (player = (Player)sender).getInventory().getItemInMainHand()).getItemMeta()).hasLore()) {
                List lore = itemMeta.lore();
                if (lore == null) {
                    return new ArrayList();
                }
                return IntStream.range(1, lore.size() + 1).mapToObj(String::valueOf).toList();
            }
            return new ArrayList();
        });
        this.addRequireArg("line", (sender, args) -> {
            Player player;
            ItemStack itemStack;
            ItemMeta itemMeta;
            if (sender instanceof Player && (itemMeta = (itemStack = (player = (Player)sender).getInventory().getItemInMainHand()).getItemMeta()).hasLore()) {
                List lore = itemMeta.lore();
                if (lore == null) {
                    return new ArrayList();
                }
                try {
                    int index = Integer.parseInt(args[1]) - 1;
                    if (itemMeta.getPersistentDataContainer().has(this.loreLineRaw, PersistentDataType.STRING)) {
                        String[] line = ((String)itemMeta.getPersistentDataContainer().getOrDefault(this.loreLineRaw, PersistentDataType.STRING, (Object)"")).split(";");
                        return Arrays.asList(line[index]);
                    }
                    Component component = (Component)lore.get(index);
                    return List.of(component == null ? "" : this.colorReverse(LegacyComponentSerializer.legacyAmpersand().serialize(component)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new ArrayList();
        });
        this.setExtendedArgs(true);
        this.onlyPlayers();
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        CharSequence[] rawLoreLines;
        ArrayList<Object> components;
        int index = this.argAsInteger(0);
        String loreLine = this.getArgs(2);
        if (loreLine.isEmpty()) {
            return CommandResultType.SYNTAX_ERROR;
        }
        ItemStack itemStack = this.player.getInventory().getItemInMainHand();
        if (itemStack.getType().isAir()) {
            this.message(this.sender, Message.COMMAND_ITEM_EMPTY, new Object[0]);
            return CommandResultType.DEFAULT;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        ArrayList<Object> arrayList = components = itemMeta.hasLore() ? itemMeta.lore() : new ArrayList();
        if (components == null) {
            components = new ArrayList<Object>();
        }
        if (components.size() < index) {
            this.message(this.sender, Message.COMMAND_ITEM_LORE_SET_ERROR, "%line%", index);
            return CommandResultType.DEFAULT;
        }
        PaperComponent paperComponent = (PaperComponent)this.componentMessage;
        if (components.size() < index) {
            for (int i = components.size(); i < index; ++i) {
                components.add(Component.text((String)""));
            }
        }
        components.set(index - 1, paperComponent.getComponent(loreLine).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE));
        itemMeta.lore(components);
        PersistentDataContainer dataContainer = itemMeta.getPersistentDataContainer();
        int newSize = itemMeta.lore() == null ? 1 : itemMeta.lore().size();
        CharSequence[] charSequenceArray = rawLoreLines = dataContainer.has(this.loreLineRaw, PersistentDataType.STRING) ? ((String)dataContainer.getOrDefault(this.loreLineRaw, PersistentDataType.STRING, (Object)"")).split(";") : new String[newSize];
        if (rawLoreLines.length < newSize) {
            String[] newRawLoreLines = new String[newSize];
            System.arraycopy(rawLoreLines, 0, newRawLoreLines, 0, rawLoreLines.length);
            rawLoreLines = newRawLoreLines;
        }
        for (int i = 0; i != components.size(); ++i) {
            if (rawLoreLines[i] != null) continue;
            rawLoreLines[i] = this.colorReverse(LegacyComponentSerializer.legacyAmpersand().serialize((Component)components.get(i)));
        }
        rawLoreLines[index - 1] = loreLine;
        String rawLoreCombined = String.join((CharSequence)";", rawLoreLines);
        dataContainer.set(this.loreLineRaw, PersistentDataType.STRING, (Object)rawLoreCombined);
        itemStack.setItemMeta(itemMeta);
        this.message(this.sender, Message.COMMAND_ITEM_LORE_SET, "%text%", loreLine, "%line%", index);
        return CommandResultType.SUCCESS;
    }
}

