/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.items;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.module.modules.ItemModule;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import fr.maxlego08.essentials.zutils.utils.paper.PaperComponent;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CommandItemName
extends VCommand {
    private final NamespacedKey itemNameRaw;

    public CommandItemName(EssentialsPlugin plugin) {
        super(plugin);
        this.itemNameRaw = new NamespacedKey((Plugin)plugin, "item-name-raw");
        this.setModule(ItemModule.class);
        this.setPermission(Permission.ESSENTIALS_ITEM_NAME);
        this.setDescription(Message.DESCRIPTION_ITEM_NAME);
        this.addOptionalArg("name", (sender, args) -> {
            ItemMeta itemMeta;
            Player player;
            ItemStack itemStack;
            if (sender instanceof Player && (itemStack = (player = (Player)sender).getInventory().getItemInMainHand()).hasItemMeta() && (itemMeta = itemStack.getItemMeta()).hasDisplayName()) {
                if (itemMeta.getPersistentDataContainer().has(this.itemNameRaw, PersistentDataType.STRING)) {
                    return List.of((String)itemMeta.getPersistentDataContainer().getOrDefault(this.itemNameRaw, PersistentDataType.STRING, (Object)""));
                }
                Component component = itemMeta.displayName();
                return List.of(component == null ? "" : this.colorReverse(LegacyComponentSerializer.legacyAmpersand().serialize(component)));
            }
            return new ArrayList();
        });
        this.setExtendedArgs(true);
        this.onlyPlayers();
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        Component component;
        String itemName = this.getArgs(0);
        ItemStack itemStack = this.player.getInventory().getItemInMainHand();
        if (itemStack.getType().isAir()) {
            this.message(this.sender, Message.COMMAND_ITEM_EMPTY, new Object[0]);
            return CommandResultType.DEFAULT;
        }
        boolean isReset = itemName.isEmpty();
        ItemMeta itemMeta = itemStack.getItemMeta();
        PaperComponent paperComponent = (PaperComponent)this.componentMessage;
        Component component2 = component = isReset ? null : paperComponent.getComponent(itemName);
        if (component != null) {
            component = component.decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
        }
        itemMeta.displayName(component);
        itemMeta.getPersistentDataContainer().set(this.itemNameRaw, PersistentDataType.STRING, (Object)itemName);
        itemStack.setItemMeta(itemMeta);
        this.message(this.sender, isReset ? Message.COMMAND_ITEM_CLEAR : Message.COMMAND_ITEM_SET, "%name%", itemName);
        return CommandResultType.SUCCESS;
    }
}

