/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.kits;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.kit.Kit;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.module.modules.kit.KitModule;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import java.util.Optional;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.permissions.Permissible;

public class CommandKit
extends VCommand {
    public CommandKit(EssentialsPlugin plugin) {
        super(plugin);
        this.setModule(KitModule.class);
        this.setPermission(Permission.ESSENTIALS_KIT);
        this.setDescription(Message.DESCRIPTION_KIT);
        this.addOptionalArg("kit", (sender, b) -> plugin.getModuleManager().getModule(KitModule.class).getKits((Permissible)sender).stream().filter(kit -> kit.hasPermission((Permissible)sender)).map(Kit::getName).toList());
        this.onlyPlayers();
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        KitModule kitModule = plugin.getModuleManager().getModule(KitModule.class);
        String kitName = this.argAsString(0, null);
        if (kitName == null) {
            if (this.sender instanceof ConsoleCommandSender) {
                kitModule.sendInLine(this.sender);
                return CommandResultType.SUCCESS;
            }
            kitModule.showKits(this.user);
            return CommandResultType.DEFAULT;
        }
        Optional<Kit> optional = kitModule.getKit(kitName);
        if (optional.isEmpty()) {
            this.message(this.sender, Message.COMMAND_KIT_NOT_FOUND, "%kit%", kitName);
            return CommandResultType.DEFAULT;
        }
        Kit kit = optional.get();
        if (!kit.hasPermission((Permissible)this.sender)) {
            this.message(this.sender, Message.COMMAND_KIT_NO_PERMISSION, "%kit%", kitName);
            return CommandResultType.DEFAULT;
        }
        if (kitModule.giveKit(this.user, kit, false)) {
            return CommandResultType.SUCCESS;
        }
        return CommandResultType.DEFAULT;
    }
}

