/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.mail;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.module.modules.ItemModule;
import fr.maxlego08.essentials.module.modules.MailBoxModule;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import org.bukkit.command.CommandSender;

public class CommandMailGive
extends VCommand {
    public CommandMailGive(EssentialsPlugin plugin) {
        super(plugin);
        this.setModule(MailBoxModule.class);
        this.setDescription(Message.DESCRIPTION_MAIL_GIVE);
        this.setPermission(Permission.ESSENTIALS_MAIL_GIVE);
        this.addSubCommand("give");
        this.addRequireOfflinePlayerNameArg();
        this.addRequireArg("item", (sender, args) -> {
            ArrayList<String> materials = new ArrayList<String>(plugin.getMaterials().stream().map(Enum::name).map(String::toLowerCase).toList());
            materials.addAll(plugin.getModuleManager().getModule(ItemModule.class).getItemsName());
            return materials;
        });
        this.addOptionalArg("amount", (sender, args) -> Arrays.asList("1", "64"));
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        String username = this.argAsString(0);
        String itemName = this.argAsString(1);
        int amount = this.argAsInteger(2, 1);
        CommandSender sender = this.sender;
        MailBoxModule module = plugin.getModuleManager().getModule(MailBoxModule.class);
        this.fetchUniqueId(username, uuid -> module.giveItem(sender, (UUID)uuid, username, itemName, amount));
        return CommandResultType.SUCCESS;
    }
}

