/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.spawn;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.module.modules.SpawnModule;
import fr.maxlego08.essentials.storage.ConfigStorage;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class CommandFirstSpawn
extends VCommand {
    public CommandFirstSpawn(EssentialsPlugin plugin) {
        super(plugin);
        this.setModule(SpawnModule.class);
        this.setPermission(Permission.ESSENTIALS_SPAWN_FIRST);
        this.setDescription(Message.DESCRIPTION_SPAWN_FIRST);
        this.addOptionalArg("player");
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        User user;
        Player player = this.argAsPlayer(0, this.player);
        if (player == null) {
            return CommandResultType.SYNTAX_ERROR;
        }
        if (this.player != null && !this.hasPermission((Permissible)this.player, Permission.ESSENTIALS_SPAWN_OTHER)) {
            player = this.player;
        }
        if ((user = this.plugin.getUser(player.getUniqueId())) == null) {
            return CommandResultType.SYNTAX_ERROR;
        }
        Location location = ConfigStorage.firstSpawnLocation.getLocation();
        if (location == null) {
            this.message(this.sender, Message.COMMAND_SPAWN_FIRST_NOT_DEFINE, new Object[0]);
            return CommandResultType.DEFAULT;
        }
        user.teleport(location, Message.TELEPORT_MESSAGE_SPAWN, Message.TELEPORT_SUCCESS_SPAWN, new Object[0]);
        if (this.user == null || user != this.user) {
            this.message(this.sender, Message.TELEPORT_MESSAGE_SPAWN_CONSOLE, player);
        }
        return CommandResultType.SUCCESS;
    }
}

