/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.teleport;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.module.modules.TeleportationModule;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class CommandTeleport
extends VCommand {
    private static final double MAX_COORDINATE = 3.0E7;

    public CommandTeleport(EssentialsPlugin plugin) {
        super(plugin);
        this.setModule(TeleportationModule.class);
        this.setPermission(Permission.ESSENTIALS_TP);
        this.setDescription(Message.DESCRIPTION_TP);
        this.addRequirePlayerNameArg();
        this.addOptionalArg("x");
        this.addOptionalArg("y");
        this.addOptionalArg("z");
        this.addOptionalArg("yaw");
        this.addOptionalArg("pitch");
        this.onlyPlayers();
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        if (this.args.length == 1) {
            Player targetPlayer = this.argAsPlayer(0);
            if (targetPlayer == null) {
                return CommandResultType.SYNTAX_ERROR;
            }
            this.user.teleportNow(targetPlayer.getLocation());
            this.message(this.sender, Message.COMMAND_TP, targetPlayer);
        } else {
            String value = this.argAsString(0);
            Location location = this.player.getLocation();
            if (this.isNumeric(value) || this.isRelativeCoordinate(value)) {
                double x = this.parseCoordinate(value, location.getX());
                double y = this.parseCoordinate(this.argAsString(1), location.getY());
                double z = this.parseCoordinate(this.argAsString(2), location.getZ());
                location.set(x, y, z);
                if (this.isLocationNotValid(location)) {
                    this.message(this.sender, Message.COMMAND_TP_LOCATION_ERROR, new Object[0]);
                    return CommandResultType.DEFAULT;
                }
                float yaw = (float)this.argAsDouble(3, location.getYaw());
                float pitch = (float)this.argAsDouble(4, location.getPitch());
                location.setYaw(yaw);
                location.setPitch(pitch);
                this.plugin.getScheduler().teleportAsync((Entity)this.player, location);
                this.message(this.sender, Message.COMMAND_TP_LOCATION, "%x%", x, "%y%", y, "%z%", z);
            } else {
                double x = this.parseCoordinate(this.argAsString(1), location.getX());
                double y = this.parseCoordinate(this.argAsString(2), location.getY());
                double z = this.parseCoordinate(this.argAsString(3), location.getZ());
                location.set(x, y, z);
                if (this.isLocationNotValid(location)) {
                    this.message(this.sender, Message.COMMAND_TP_LOCATION_ERROR, new Object[0]);
                    return CommandResultType.DEFAULT;
                }
                if (value.equalsIgnoreCase("@s")) {
                    float yaw = (float)this.argAsDouble(4, this.player.getLocation().getYaw());
                    float pitch = (float)this.argAsDouble(5, this.player.getLocation().getPitch());
                    location.setYaw(yaw);
                    location.setPitch(pitch);
                    this.plugin.getScheduler().teleportAsync((Entity)this.player, location);
                    this.message(this.sender, Message.COMMAND_TP_LOCATION, "%x%", x, "%y%", y, "%z%", z);
                } else {
                    Player targetPlayer = this.argAsPlayer(0);
                    if (targetPlayer == null) {
                        return CommandResultType.SYNTAX_ERROR;
                    }
                    float yaw = (float)this.argAsDouble(4, targetPlayer.getLocation().getYaw());
                    float pitch = (float)this.argAsDouble(5, targetPlayer.getLocation().getPitch());
                    location.setYaw(yaw);
                    location.setPitch(pitch);
                    this.plugin.getScheduler().teleportAsync((Entity)targetPlayer, location);
                    this.message(this.sender, Message.COMMAND_TP_LOCATION_OTHER, "%x%", x, "%y%", y, "%z%", z, targetPlayer);
                }
            }
        }
        return CommandResultType.SUCCESS;
    }

    private boolean isNumeric(String strNum) {
        if (strNum == null) {
            return false;
        }
        try {
            double d = Double.parseDouble(strNum);
        }
        catch (NumberFormatException ignored) {
            return false;
        }
        return true;
    }

    private boolean isRelativeCoordinate(String coordinate) {
        return coordinate != null && coordinate.startsWith("~");
    }

    private double parseCoordinate(String coordinate, double current) {
        if (coordinate == null) {
            return current;
        }
        if (coordinate.startsWith("~")) {
            if (coordinate.length() == 1) {
                return current;
            }
            return current + Double.parseDouble(coordinate.substring(1));
        }
        return Double.parseDouble(coordinate);
    }

    private boolean isLocationNotValid(Location location) {
        if (location.getWorld() == null) {
            return true;
        }
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z)) {
            return true;
        }
        if (Double.isInfinite(x) || Double.isInfinite(y) || Double.isInfinite(z)) {
            return true;
        }
        if (Math.abs(x) > 3.0E7 || Math.abs(z) > 3.0E7) {
            return true;
        }
        return !(y >= (double)location.getWorld().getMinHeight()) || !(y <= (double)location.getWorld().getMaxHeight());
    }
}

