/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.teleport;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.module.modules.TeleportationModule;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import org.bukkit.entity.Player;

public class CommandTeleportToHere
extends VCommand {
    public CommandTeleportToHere(EssentialsPlugin plugin) {
        super(plugin);
        this.setModule(TeleportationModule.class);
        this.setPermission(Permission.ESSENTIALS_TPA_HERE);
        this.setDescription(Message.DESCRIPTION_TPA_HERE);
        this.addRequirePlayerNameArg();
        this.onlyPlayers();
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        Player targetPlayer = this.argAsPlayer(0);
        if (targetPlayer == null) {
            return CommandResultType.SYNTAX_ERROR;
        }
        User targetUser = plugin.getStorageManager().getStorage().getUser(targetPlayer.getUniqueId());
        if (targetUser.getUniqueId().equals(this.player.getUniqueId())) {
            this.message(this.sender, Message.COMMAND_TPA_ERROR_SAME, new Object[0]);
            return CommandResultType.DEFAULT;
        }
        TeleportationModule teleportationModule = plugin.getModuleManager().getModule(TeleportationModule.class);
        if (teleportationModule.isOpenConfirmInventoryForTpaHere()) {
            this.user.setTargetUser(targetUser);
            teleportationModule.openConfirmInventory(this.player);
            return CommandResultType.SUCCESS;
        }
        this.user.sendTeleportHereRequest(targetUser);
        return CommandResultType.SUCCESS;
    }
}

