/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.utils;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.user.Option;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import java.text.DecimalFormat;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class CommandNear
extends VCommand {
    public CommandNear(EssentialsPlugin plugin) {
        super(plugin);
        this.setPermission(Permission.ESSENTIALS_NEAR);
        this.setDescription(Message.DESCRIPTION_NEAR);
        this.onlyPlayers();
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        double distance = plugin.getConfiguration().getNearDistance((Permissible)this.player);
        List<Player> players = this.player.getWorld().getNearbyPlayers(this.player.getLocation(), distance).stream().filter(player -> {
            User user = plugin.getUser(player.getUniqueId());
            return user == null || !user.getOption(Option.VANISH);
        }).filter(player -> player != this.player).toList();
        if (players.isEmpty()) {
            this.message(this.sender, Message.COMMAND_NEAR_EMPTY, new Object[0]);
        } else {
            DecimalFormat decimalFormat = new DecimalFormat("#.##");
            this.message(this.sender, Message.COMMAND_NEAR_PLAYER, "%players%", String.join((CharSequence)",", players.stream().map(player -> this.getMessage(Message.COMMAND_NEAR_INFO, "%player%", player.getName(), "%distance%", decimalFormat.format(player.getLocation().distance(this.player.getLocation())))).toList()));
        }
        return CommandResultType.SUCCESS;
    }
}

