/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.utils.admins;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import java.util.Arrays;
import org.bukkit.entity.Player;

public class CommandSpeed
extends VCommand {
    public CommandSpeed(EssentialsPlugin plugin) {
        super(plugin);
        this.setPermission(Permission.ESSENTIALS_SPEED);
        this.setDescription(Message.DESCRIPTION_SPEED);
        this.addRequireArg("speed", (a, b) -> Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10"));
        this.addOptionalArg("player");
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        Message speedTypeMessage;
        int speed = this.argAsInteger(0);
        Player player = this.argAsPlayer(1, this.player);
        if (speed < 0 || speed > 10) {
            this.message(this.sender, Message.COMMAND_SPEED_ERROR, new Object[0]);
            return CommandResultType.DEFAULT;
        }
        if (player == null) {
            this.message(this.sender, Message.COMMAND_SPEED_INVALID, new Object[0]);
            return CommandResultType.DEFAULT;
        }
        float speedFloat = (float)speed / 10.0f;
        boolean isFlying = player.isFlying();
        Message message = speedTypeMessage = isFlying ? Message.COMMAND_SPEED_FLY : Message.COMMAND_SPEED_WALK;
        if (isFlying) {
            player.setFlySpeed(speedFloat);
        } else {
            player.setWalkSpeed(speedFloat);
        }
        String playerNameOrYou = player == this.player ? Message.YOU.getMessageAsString() : player.getName();
        this.message(this.sender, speedTypeMessage, "%speed%", speed, "%player%", playerNameOrYou);
        return CommandResultType.SUCCESS;
    }
}

