/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.worldedit;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.EssentialsCommand;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.worldedit.MaterialPercent;
import fr.maxlego08.essentials.module.modules.worldedit.WorldeditModule;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class WorldeditCommand
extends VCommand {
    protected int indexMaterial = 1;

    public WorldeditCommand(EssentialsPlugin plugin) {
        super(plugin);
        this.setModule(WorldeditModule.class);
        this.addRequireArg("material");
        this.setTabCompleter();
        this.onlyPlayers();
    }

    @Override
    public List<String> toTab(EssentialsPlugin plugin, CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            return null;
        }
        Player player = (Player)sender;
        List<String> materials = plugin.getWorldeditManager().getAllowedMaterials(player);
        if (args.length == 2) {
            return this.worldeditTab(plugin, args, player);
        }
        String startWith = args[args.length - 1];
        ArrayList<String> tabCompleter = new ArrayList<String>();
        for (EssentialsCommand vCommand : plugin.getCommandManager().getCommands()) {
            if (vCommand.getParent() == null || vCommand.getParent() != this) continue;
            String cmd = vCommand.getSubCommands().get(0);
            if (vCommand.getPermission() != null && !sender.hasPermission(vCommand.getPermission()) || startWith.length() != 0 && !cmd.startsWith(startWith)) continue;
            tabCompleter.add(cmd);
        }
        return tabCompleter.size() == 0 ? null : tabCompleter;
    }

    public List<String> worldeditTab(EssentialsPlugin plugin, String[] args, Player player) {
        String rawMaterial;
        List<String> materials = plugin.getWorldeditManager().getAllowedMaterials(player);
        String currentItem = args[this.indexMaterial];
        Object completedString = "";
        if (currentItem.contains(",")) {
            currentItem = args[this.indexMaterial].substring(args[this.indexMaterial].lastIndexOf(",") + 1);
            completedString = args[this.indexMaterial].substring(0, args[this.indexMaterial].lastIndexOf(",") + 1);
        }
        if (currentItem.contains("%")) {
            String[] split = currentItem.split("%");
            rawMaterial = split[split.length - 1];
            completedString = (String)completedString + split[0] + "%";
        } else {
            rawMaterial = currentItem;
        }
        String finalCompletedString = completedString;
        return materials.stream().filter(s -> s.startsWith(rawMaterial.toLowerCase())).map(name -> finalCompletedString + name).toList();
    }

    protected MaterialPercent getMaterialPercent(String value, int percent) {
        if (value.contains(":")) {
            String[] split = value.split(":");
            return new MaterialPercent(Material.valueOf((String)split[0]), Integer.parseInt(split[1]));
        }
        return new MaterialPercent(Material.valueOf((String)value), percent);
    }

    protected WorldEditCommandResult getMaterialPercents() {
        String materials = this.argAsString(0).toUpperCase();
        ArrayList<MaterialPercent> materialPercents = new ArrayList<MaterialPercent>();
        if (materials.contains(",")) {
            String[] values;
            for (String value : values = materials.split(",")) {
                try {
                    materialPercents.add(this.getMaterialPercent(value, 100 / values.length));
                }
                catch (Exception exception) {
                    this.message(this.sender, Message.COMMAND_WORLDEDIT_MATERIAL_NOT_FOUND, "%material%", value);
                    return new WorldEditCommandResult(CommandResultType.DEFAULT, new ArrayList<MaterialPercent>());
                }
            }
        } else {
            try {
                materialPercents.add(this.getMaterialPercent(materials, 100));
            }
            catch (Exception exception) {
                this.message(this.sender, Message.COMMAND_WORLDEDIT_MATERIAL_NOT_FOUND, "%material%", materials);
                return new WorldEditCommandResult(CommandResultType.DEFAULT, new ArrayList<MaterialPercent>());
            }
        }
        materialPercents.removeIf(materialPercent -> this.plugin.getWorldeditManager().isBlacklist(materialPercent.material()));
        return new WorldEditCommandResult(CommandResultType.SUCCESS, materialPercents);
    }

    public record WorldEditCommandResult(CommandResultType commandResultType, List<MaterialPercent> materialPercents) {
    }
}

