/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.convert.coinsengine;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.convert.Convert;
import fr.maxlego08.essentials.api.economy.Economy;
import fr.maxlego08.essentials.api.economy.EconomyManager;
import fr.maxlego08.essentials.api.storage.IStorage;
import fr.maxlego08.essentials.libs.sarah.DatabaseConfiguration;
import fr.maxlego08.essentials.libs.sarah.SchemaBuilder;
import fr.maxlego08.essentials.libs.sarah.SqliteConnection;
import fr.maxlego08.essentials.libs.sarah.database.Schema;
import fr.maxlego08.essentials.libs.sarah.logger.JULogger;
import fr.maxlego08.essentials.libs.sarah.logger.Logger;
import fr.maxlego08.essentials.storage.database.repositeries.UserEconomyRepository;
import fr.maxlego08.essentials.storage.storages.SqlStorage;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.io.File;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;

public class CoinsEngineConvert
extends ZUtils
implements Convert {
    private final EssentialsPlugin plugin;

    public CoinsEngineConvert(EssentialsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void convert(CommandSender sender) {
        this.message(sender, "&fStart convert &7CoinsEngine");
        File folder = new File(Bukkit.getWorldContainer(), "plugins/CoinsEngine");
        if (!folder.exists()) {
            this.message(sender, "&cUnable to find &bplugins/CoinsEngine&c.");
            return;
        }
        IStorage iStorage = this.plugin.getStorageManager().getStorage();
        if (iStorage instanceof SqlStorage) {
            SqlStorage sqlStorage = (SqlStorage)iStorage;
            this.plugin.getScheduler().runAsync(wrappedTask -> {
                try {
                    this.startConvertDatabase(sender, sqlStorage, folder);
                }
                catch (SQLException exception) {
                    this.message(sender, "&cImpossible to convert CoinsEngine: " + exception.getMessage());
                    exception.printStackTrace();
                }
            });
        } else {
            this.message(sender, "&cYou must have the storage in a database to be able to convert. Never use the storage in JSON !");
        }
    }

    private void startConvertDatabase(CommandSender sender, SqlStorage sqlStorage, File folder) throws SQLException {
        SqliteConnection databaseConnection = new SqliteConnection(DatabaseConfiguration.sqlite(sqlStorage.getConnection().getDatabaseConfiguration().isDebug()), folder);
        databaseConnection.setFileName("data.db");
        if (!databaseConnection.isValid()) {
            this.message(sender, "&cUnable to connect to database.");
        }
        List<String> columns = this.getColumns(folder);
        EconomyManager economyManager = this.plugin.getEconomyManager();
        for (String column : columns) {
            if (!economyManager.getEconomy(column).isEmpty()) continue;
            this.message(sender, "&cUnable to find the economy \u00a7f" + column + "\u00a7c. You must create the savings in the \u00a7fmodules/economy/config.yml \u00a7cfile before converting the data.");
            return;
        }
        Logger logger = JULogger.from(this.plugin.getLogger());
        UserEconomyRepository userEconomyRepository = sqlStorage.with(UserEconomyRepository.class);
        Schema schema = SchemaBuilder.select("coinsengine_users");
        List<Map<String, Object>> result = schema.executeSelect(databaseConnection, logger);
        this.message(sender, "&aFound &f" + result.size() + " &ausers.");
        result.forEach(map -> {
            UUID uuid = UUID.fromString((String)map.get("uuid"));
            columns.forEach(column -> {
                Number number = (Number)map.get(column);
                Economy economy = economyManager.getEconomy((String)column).get();
                userEconomyRepository.upsert(uuid, economy, this.convertToBigDecimal(number));
            });
        });
        this.message(sender, "&aYou have just converted your CoinsEngine data to zEssentials !");
    }

    private List<String> getColumns(File folder) {
        File currenciesFolder = new File(folder, "currencies");
        if (!currenciesFolder.exists()) {
            return new ArrayList<String>();
        }
        File[] files = currenciesFolder.listFiles();
        if (files == null || files.length == 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> currencies = new ArrayList<String>();
        for (File file : files) {
            YamlConfiguration configuration;
            String column;
            if (!file.getName().endsWith(".yml") || (column = (configuration = YamlConfiguration.loadConfiguration((File)file)).getString("Column_Name")) == null) continue;
            currencies.add(column);
        }
        return currencies;
    }

    private BigDecimal convertToBigDecimal(Number number) {
        if (number instanceof Integer || number instanceof Long || number instanceof Short || number instanceof Byte) {
            return BigDecimal.valueOf(number.longValue());
        }
        if (number instanceof Double) {
            return BigDecimal.valueOf(number.doubleValue());
        }
        return new BigDecimal(number.toString());
    }
}

