/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.convert.essentialsx;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.convert.Convert;
import fr.maxlego08.essentials.api.home.Home;
import fr.maxlego08.essentials.api.storage.IStorage;
import fr.maxlego08.essentials.api.utils.SafeLocation;
import fr.maxlego08.essentials.storage.database.repositeries.UserEconomyRepository;
import fr.maxlego08.essentials.storage.database.repositeries.UserHomeRepository;
import fr.maxlego08.essentials.storage.database.repositeries.UserRepository;
import fr.maxlego08.essentials.storage.storages.SqlStorage;
import fr.maxlego08.essentials.user.ZHome;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class EssentialsXConvert
extends ZUtils
implements Convert {
    private final EssentialsPlugin plugin;

    public EssentialsXConvert(EssentialsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void convert(CommandSender sender) {
        this.message(sender, "&fStart convert &7EssentialX");
        File folder = new File("plugins/Essentials/userdata");
        if (!folder.exists()) {
            this.message(sender, "&cUnable to find the folder &bplugins/Essentials/userdata&c.");
            return;
        }
        IStorage iStorage = this.plugin.getStorageManager().getStorage();
        if (iStorage instanceof SqlStorage) {
            SqlStorage sqlStorage = (SqlStorage)iStorage;
            this.plugin.getScheduler().runAsync(wrappedTask -> this.startConvertDatabase(sender, sqlStorage, folder));
        } else {
            this.message(sender, "&cYou must have the storage in a database to be able to convert. Never use the storage in JSON !");
        }
    }

    private void startConvertDatabase(CommandSender sender, SqlStorage sqlStorage, File folder) {
        File[] files = folder.listFiles();
        if (files == null || files.length == 0) {
            this.message(sender, "&cNo files found in the userdata folder!");
            return;
        }
        this.message(sender, "&aFound &f" + files.length + " &ausers.");
        for (File file : files) {
            this.loadUser(sqlStorage, file, sender);
        }
        this.message(sender, "&aYou have just converted your EssentialsX data to zEssentials !");
    }

    private void loadUser(SqlStorage sqlStorage, File file, CommandSender sender) {
        String fileName = file.getName();
        if (!fileName.endsWith(".yml")) {
            return;
        }
        try {
            UUID uniqueId = UUID.fromString(fileName.replace(".yml", ""));
            UserRepository userRepository = sqlStorage.with(UserRepository.class);
            UserEconomyRepository userEconomyRepository = sqlStorage.with(UserEconomyRepository.class);
            UserHomeRepository userHomeRepository = sqlStorage.with(UserHomeRepository.class);
            YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
            String money = configuration.getString("money", "0");
            this.plugin.getScheduler().runAsync(wrappedTask -> {
                String lastName = configuration.getString("last-account-name");
                if (lastName == null) {
                    this.plugin.getLogger().warning("Impossible to find the name of " + String.valueOf(uniqueId) + ", try with offline player");
                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uniqueId);
                    if (offlinePlayer.getName() == null) {
                        this.plugin.getLogger().warning("Impossible to find the name of " + String.valueOf(uniqueId) + ", even with an offline player, skip.");
                        return;
                    }
                    lastName = offlinePlayer.getName();
                }
                userRepository.upsert(uniqueId, lastName);
                userEconomyRepository.upsert(uniqueId, this.plugin.getEconomyManager().getDefaultEconomy(), new BigDecimal(money));
                List<Home> homes = this.parseHomes(configuration);
                homes.forEach(home -> userHomeRepository.upsert(uniqueId, (Home)home));
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    this.plugin.getComponentMessage().sendActionBar(player, "&fConvert user &7" + String.valueOf(uniqueId));
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.plugin.getLogger().severe("Impossible to load the file " + file.getName());
        }
        this.message(sender, "&aYou have just converted your EssentialsX data to zEssentials !");
    }

    private List<Home> parseHomes(YamlConfiguration configuration) {
        ArrayList<Home> homes = new ArrayList<Home>();
        ConfigurationSection configurationSection = configuration.getConfigurationSection("homes");
        if (configurationSection != null) {
            configurationSection.getKeys(false).forEach(homeName -> {
                String world = configurationSection.getString(homeName + ".world-name", "world");
                double x = configurationSection.getDouble(homeName + ".x");
                double y = configurationSection.getDouble(homeName + ".y");
                double z = configurationSection.getDouble(homeName + ".z");
                double yaw = configurationSection.getDouble(homeName + ".yaw");
                double pitch = configurationSection.getDouble(homeName + ".pitch");
                ZHome home = new ZHome(new SafeLocation(world, x, y, z, (float)yaw, (float)pitch), (String)homeName, null);
                homes.add(home);
            });
        }
        return homes;
    }
}

