/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.convert.huskhomes;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.convert.Convert;
import fr.maxlego08.essentials.api.storage.IStorage;
import fr.maxlego08.essentials.api.utils.SafeLocation;
import fr.maxlego08.essentials.convert.huskhomes.HuskHome;
import fr.maxlego08.essentials.convert.huskhomes.HuskPosition;
import fr.maxlego08.essentials.convert.huskhomes.HuskSavedPosition;
import fr.maxlego08.essentials.convert.huskhomes.HuskUser;
import fr.maxlego08.essentials.libs.sarah.DatabaseConfiguration;
import fr.maxlego08.essentials.libs.sarah.DatabaseConnection;
import fr.maxlego08.essentials.libs.sarah.RequestHelper;
import fr.maxlego08.essentials.libs.sarah.SqliteConnection;
import fr.maxlego08.essentials.storage.database.repositeries.UserHomeRepository;
import fr.maxlego08.essentials.storage.database.repositeries.UserRepository;
import fr.maxlego08.essentials.storage.storages.SqlStorage;
import fr.maxlego08.essentials.user.ZHome;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.bukkit.command.CommandSender;

public class HuskHomesConvert
extends ZUtils
implements Convert {
    private final EssentialsPlugin plugin;

    public HuskHomesConvert(EssentialsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void convert(CommandSender sender) {
        this.message(sender, "&fStart convert &7HuskHomes");
        IStorage iStorage = this.plugin.getStorageManager().getStorage();
        if (iStorage instanceof SqlStorage) {
            SqlStorage sqlStorage = (SqlStorage)iStorage;
            this.plugin.getScheduler().runAsync(wrappedTask -> this.startConvertDatabase(sender, sqlStorage));
        } else {
            this.message(sender, "&cYou must have the storage in a database to be able to convert. Never use the storage in JSON !");
        }
    }

    private void startConvertDatabase(CommandSender sender, SqlStorage sqlStorage) {
        DatabaseConnection databaseConnection = sqlStorage.getConnection();
        File file = new File(this.plugin.getDataFolder(), "HuskHomesData.db");
        if (file.exists()) {
            SqliteConnection sqliteConnection = new SqliteConnection(DatabaseConfiguration.sqlite(sqlStorage.getConnection().getDatabaseConfiguration().isDebug()), this.plugin.getDataFolder());
            sqliteConnection.setFileName("HuskHomesData.db");
            databaseConnection = sqliteConnection;
            if (!databaseConnection.isValid()) {
                this.message(sender, "&cUnable to connect to database.");
                return;
            }
        }
        RequestHelper requestHelper = new RequestHelper(databaseConnection, message -> this.plugin.getLogger().info(message));
        List<HuskUser> users = requestHelper.selectAll("huskhomes_users", HuskUser.class);
        List<HuskHome> homes = requestHelper.selectAll("huskhomes_homes", HuskHome.class);
        List<HuskPosition> positions = requestHelper.selectAll("huskhomes_position_data", HuskPosition.class);
        List<HuskSavedPosition> savedPositions = requestHelper.selectAll("huskhomes_saved_positions", HuskSavedPosition.class);
        UserHomeRepository userHomeRepository = sqlStorage.with(UserHomeRepository.class);
        UserRepository userRepository = sqlStorage.with(UserRepository.class);
        this.message(sender, "&aFound &f" + homes.size() + " &ahomes and \u00a7f" + users.size() + " \u00a7ausers.");
        users.forEach(user -> userRepository.upsert(user.uuid(), user.username()));
        homes.forEach(home -> {
            Optional<HuskSavedPosition> optional = savedPositions.stream().filter(position -> position.id() == home.saved_position_id()).findFirst();
            if (optional.isEmpty()) {
                this.plugin.getLogger().severe("Impossible to find home saved position with id " + home.saved_position_id() + " for home " + String.valueOf(home.uuid()));
                return;
            }
            HuskSavedPosition savedPosition = optional.get();
            Optional<HuskPosition> optionalPosition = positions.stream().filter(position -> position.id() == savedPosition.position_id()).findFirst();
            if (optionalPosition.isEmpty()) {
                this.plugin.getLogger().severe("Impossible to find home position with id " + savedPosition.position_id() + " for home " + String.valueOf(home.uuid()));
                return;
            }
            HuskPosition position2 = optionalPosition.get();
            SafeLocation location = new SafeLocation(position2.world_name(), position2.x(), position2.y(), position2.z(), (float)position2.yaw(), (float)position2.pitch());
            userHomeRepository.upsert(home.owner_uuid(), new ZHome(location, savedPosition.name(), null));
        });
        this.message(sender, "&aYou have just converted your HuskHomes data to zEssentials !");
    }
}

