/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.convert.sunlight;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.convert.Convert;
import fr.maxlego08.essentials.api.home.Home;
import fr.maxlego08.essentials.api.storage.IStorage;
import fr.maxlego08.essentials.convert.sunlight.SunlightHome;
import fr.maxlego08.essentials.convert.sunlight.SunlightUser;
import fr.maxlego08.essentials.libs.sarah.DatabaseConfiguration;
import fr.maxlego08.essentials.libs.sarah.RequestHelper;
import fr.maxlego08.essentials.libs.sarah.SqliteConnection;
import fr.maxlego08.essentials.storage.database.repositeries.UserHomeRepository;
import fr.maxlego08.essentials.storage.database.repositeries.UserRepository;
import fr.maxlego08.essentials.storage.storages.SqlStorage;
import fr.maxlego08.essentials.user.ZHome;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.io.File;
import java.util.List;
import org.bukkit.command.CommandSender;

public class SunlightConvert
extends ZUtils
implements Convert {
    private final EssentialsPlugin plugin;

    public SunlightConvert(EssentialsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void convert(CommandSender sender) {
        this.message(sender, "&fStart convert &7Sunlight");
        File file = new File(this.plugin.getDataFolder(), "data.db");
        if (!file.exists()) {
            this.message(sender, "&cUnable to find &bdata.db &cfile in &fplugins/zEssentials&c.");
            return;
        }
        IStorage iStorage = this.plugin.getStorageManager().getStorage();
        if (iStorage instanceof SqlStorage) {
            SqlStorage sqlStorage = (SqlStorage)iStorage;
            this.plugin.getScheduler().runAsync(wrappedTask -> this.startConvertDatabase(sender, sqlStorage));
        } else {
            this.message(sender, "&cYou must have the storage in a database to be able to convert. Never use the storage in JSON !");
        }
    }

    private void startConvertDatabase(CommandSender sender, SqlStorage sqlStorage) {
        SqliteConnection databaseConnection = new SqliteConnection(DatabaseConfiguration.sqlite(sqlStorage.getConnection().getDatabaseConfiguration().isDebug()), this.plugin.getDataFolder());
        databaseConnection.setFileName("data.db");
        if (!databaseConnection.isValid()) {
            this.message(sender, "&cUnable to connect to database.");
        }
        RequestHelper requestHelper = new RequestHelper(databaseConnection, message -> this.plugin.getLogger().info(message));
        List<SunlightUser> sunlightUsers = requestHelper.select("sunlight_users", SunlightUser.class, table -> {});
        List<SunlightHome> sunlightHomes = requestHelper.select("sunlight_homes", SunlightHome.class, table -> {});
        this.message(sender, "&aFound &f" + sunlightUsers.size() + " &ausers and &f" + sunlightHomes.size() + " &ahomes.");
        UserRepository userRepository = sqlStorage.with(UserRepository.class);
        UserHomeRepository userHomeRepository = sqlStorage.with(UserHomeRepository.class);
        sunlightUsers.forEach(sunlightUser -> {
            if (sunlightUser.name() == null || sunlightUser.uuid() == null) {
                return;
            }
            userRepository.upsert((SunlightUser)sunlightUser);
        });
        sunlightHomes.forEach(sunlightHome -> this.storeHomes(userHomeRepository, (SunlightHome)sunlightHome));
        this.message(sender, "&aYou have just converted your Sunlight data to zEssentials !");
    }

    private void storeHomes(UserHomeRepository userHomeRepository, SunlightHome sunlightHome) {
        try {
            Home home = this.parseHomes(sunlightHome);
            userHomeRepository.upsert(sunlightHome.ownerId(), home);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Home parseHomes(SunlightHome sunlightHome) {
        String[] location = sunlightHome.location().split(",");
        String homeLocation = location[5] + "," + location[0] + "," + location[1] + "," + location[2] + "," + location[3] + "," + location[4];
        return new ZHome(this.stringAsLocation(homeLocation), sunlightHome.name(), null);
    }
}

