/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.libs.sarah;

import fr.maxlego08.essentials.libs.sarah.DatabaseConfiguration;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class DatabaseConnection {
    protected final DatabaseConfiguration databaseConfiguration;
    protected Connection connection;

    public DatabaseConnection(DatabaseConfiguration databaseConfiguration) {
        this.databaseConfiguration = databaseConfiguration;
    }

    public DatabaseConfiguration getDatabaseConfiguration() {
        return this.databaseConfiguration;
    }

    public boolean isValid() {
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.isConnected(this.connection)) {
            try {
                Connection temp_connection = this.connectToDatabase();
                if (this.isConnected(temp_connection)) {
                    temp_connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        return true;
    }

    protected boolean isConnected(Connection connection) {
        if (connection == null) {
            return false;
        }
        try {
            return !connection.isClosed() && connection.isValid(1);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void disconnect() {
        if (this.isConnected(this.connection)) {
            try {
                this.connection.close();
            }
            catch (SQLException exception) {
                exception.printStackTrace();
            }
        }
    }

    public void connect() {
        if (!this.isConnected(this.connection)) {
            try {
                this.connection = this.connectToDatabase();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public abstract Connection connectToDatabase() throws Exception;

    public Connection getConnection() {
        this.connect();
        return this.connection;
    }
}

