/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.libs.sarah.requests;

import fr.maxlego08.essentials.libs.sarah.DatabaseConfiguration;
import fr.maxlego08.essentials.libs.sarah.DatabaseConnection;
import fr.maxlego08.essentials.libs.sarah.conditions.ColumnDefinition;
import fr.maxlego08.essentials.libs.sarah.database.Executor;
import fr.maxlego08.essentials.libs.sarah.database.Schema;
import fr.maxlego08.essentials.libs.sarah.logger.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class InsertAllRequest
implements Executor {
    private final Schema schema;
    private final String toTableName;

    public InsertAllRequest(Schema schema, String toTableName) {
        this.schema = schema;
        this.toTableName = toTableName;
    }

    @Override
    public int execute(DatabaseConnection databaseConnection, DatabaseConfiguration databaseConfiguration, Logger logger) {
        StringBuilder insertBuilder = new StringBuilder("INSERT INTO " + this.toTableName + " (");
        StringBuilder columns = new StringBuilder();
        int size = this.schema.getColumns().size();
        for (int i = 0; i < size; ++i) {
            ColumnDefinition columnDefinition = this.schema.getColumns().get(i);
            columns.append(columnDefinition.getSafeName());
            if (i >= size - 1) continue;
            columns.append(",");
        }
        insertBuilder.append((CharSequence)columns).append(") ");
        insertBuilder.append("SELECT ").append((CharSequence)columns);
        insertBuilder.append(" FROM ");
        insertBuilder.append(this.schema.getTableName());
        String insertQuery = databaseConfiguration.replacePrefix(insertBuilder.toString());
        if (databaseConfiguration.isDebug()) {
            logger.info("Executing SQL: " + insertQuery);
        }
        try (Connection connection = databaseConnection.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(insertQuery);){
            preparedStatement.executeUpdate();
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            return -1;
        }
        return 0;
    }
}

