/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.libs.sarah.requests;

import fr.maxlego08.essentials.libs.sarah.DatabaseConfiguration;
import fr.maxlego08.essentials.libs.sarah.DatabaseConnection;
import fr.maxlego08.essentials.libs.sarah.SchemaBuilder;
import fr.maxlego08.essentials.libs.sarah.database.Executor;
import fr.maxlego08.essentials.libs.sarah.database.Schema;
import fr.maxlego08.essentials.libs.sarah.database.SchemaType;
import fr.maxlego08.essentials.libs.sarah.logger.Logger;
import fr.maxlego08.essentials.libs.sarah.requests.DropTableRequest;
import fr.maxlego08.essentials.libs.sarah.requests.InsertAllRequest;
import fr.maxlego08.essentials.libs.sarah.requests.RenameExecutor;
import java.sql.SQLException;

public class ModifyRequest
implements Executor {
    private final Schema schema;

    public ModifyRequest(Schema schema) {
        this.schema = schema;
    }

    @Override
    public int execute(DatabaseConnection databaseConnection, DatabaseConfiguration databaseConfiguration, Logger logger) {
        String tmpTableName = this.schema.getTableName() + "_tmp";
        Schema tmpSchema = SchemaBuilder.copy(tmpTableName, SchemaType.CREATE, this.schema);
        try {
            tmpSchema.execute(databaseConnection, logger);
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            return -1;
        }
        Executor executor = new InsertAllRequest(this.schema, tmpTableName);
        executor.execute(databaseConnection, databaseConfiguration, logger);
        executor = new DropTableRequest(this.schema);
        executor.execute(databaseConnection, databaseConfiguration, logger);
        executor = new RenameExecutor(SchemaBuilder.rename(tmpTableName, this.schema.getTableName()));
        executor.execute(databaseConnection, databaseConfiguration, logger);
        return 0;
    }
}

