/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules.chat;

import fr.maxlego08.essentials.api.chat.ChatDisplay;
import fr.maxlego08.essentials.api.utils.component.AdventureComponent;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class CustomDisplay
extends ZUtils
implements ChatDisplay {
    private final String name;
    private final Pattern pattern;
    private final String result;
    private final String permission;

    public CustomDisplay(String name, String regex, String result, String permission) {
        this.name = name;
        this.pattern = Pattern.compile(regex);
        this.result = result;
        this.permission = permission;
    }

    @Override
    public String display(AdventureComponent adventureComponent, TagResolver.Builder builder, Player sender, Player receiver, String message) {
        Matcher matcher = this.pattern.matcher(message);
        StringBuilder formattedMessage = new StringBuilder();
        boolean result = matcher.find();
        if (!result) {
            return message;
        }
        while (result) {
            matcher.appendReplacement(formattedMessage, "<" + this.name + ">");
            result = matcher.find();
        }
        builder.resolver((TagResolver)Placeholder.component((String)this.name, (ComponentLike)adventureComponent.getComponent(this.papi(this.result.replace("%player%", sender.getName()), sender))));
        matcher.appendTail(formattedMessage);
        return formattedMessage.toString();
    }

    @Override
    public boolean hasPermission(Permissible permissible) {
        return permissible.hasPermission(this.permission);
    }
}

