/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules.worldedit;

import fr.maxlego08.essentials.ZEssentialsPlugin;
import fr.maxlego08.essentials.api.configuration.NonLoadable;
import fr.maxlego08.essentials.api.economy.Economy;
import fr.maxlego08.essentials.api.economy.EconomyManager;
import fr.maxlego08.essentials.api.event.events.user.UserQuitEvent;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.user.Option;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.api.utils.component.AdventureComponent;
import fr.maxlego08.essentials.api.worldedit.BlockPrice;
import fr.maxlego08.essentials.api.worldedit.MaterialPercent;
import fr.maxlego08.essentials.api.worldedit.PermissionBlockPerSecond;
import fr.maxlego08.essentials.api.worldedit.PermissionHeight;
import fr.maxlego08.essentials.api.worldedit.PermissionMaxBlocks;
import fr.maxlego08.essentials.api.worldedit.PermissionMaxDistance;
import fr.maxlego08.essentials.api.worldedit.PermissionRadius;
import fr.maxlego08.essentials.api.worldedit.Selection;
import fr.maxlego08.essentials.api.worldedit.WorldEditItem;
import fr.maxlego08.essentials.api.worldedit.WorldEditTask;
import fr.maxlego08.essentials.api.worldedit.WorldeditBossBar;
import fr.maxlego08.essentials.api.worldedit.WorldeditBossBarConfiguration;
import fr.maxlego08.essentials.api.worldedit.WorldeditManager;
import fr.maxlego08.essentials.api.worldedit.WorldeditStatus;
import fr.maxlego08.essentials.module.ZModule;
import fr.maxlego08.essentials.module.modules.worldedit.bossbar.PaperBossBar;
import fr.maxlego08.essentials.module.modules.worldedit.taks.CutTask;
import fr.maxlego08.essentials.module.modules.worldedit.taks.CylTask;
import fr.maxlego08.essentials.module.modules.worldedit.taks.FillTask;
import fr.maxlego08.essentials.module.modules.worldedit.taks.SetTask;
import fr.maxlego08.essentials.module.modules.worldedit.taks.SphereTask;
import fr.maxlego08.essentials.module.modules.worldedit.taks.WallsTask;
import fr.maxlego08.essentials.zutils.utils.TimerBuilder;
import fr.maxlego08.menu.ZMenuItemStack;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.MenuItemStack;
import fr.maxlego08.menu.api.utils.TypedMapAccessor;
import fr.maxlego08.menu.zcore.utils.itemstack.MenuItemStackFormMap;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class WorldeditModule
extends ZModule
implements WorldeditManager {
    @NonLoadable
    private final List<WorldEditItem> worldEditItems = new ArrayList<WorldEditItem>();
    private final List<String> blacklistBlocks = new ArrayList<String>();
    @NonLoadable
    private final WorldeditBossBar bossBar;
    private final boolean enableColorVisualisation = false;
    private final boolean openHelpInventory = false;
    private BigDecimal defaultBlockPrice;
    private List<BlockPrice> blocksPrice;
    private List<PermissionBlockPerSecond> permissionsBlocksPerSecond;
    private List<PermissionMaxBlocks> permissionsMaxBlocks;
    private List<PermissionMaxDistance> permissionsMaxDistances;
    private List<PermissionRadius> permissionsSphereRadius;
    private List<PermissionRadius> permissionsCylinderRadius;
    private List<PermissionHeight> permissionsSphereHeight;
    private List<PermissionHeight> permissionsCylinderHeight;
    private int batchSize;
    private WorldeditBossBarConfiguration worldeditBossBar;
    private String withdrawReason;
    private String refundReason;
    private List<String> blacklistWorlds;

    public WorldeditModule(ZEssentialsPlugin plugin) {
        super(plugin, "worldedit");
        this.bossBar = new PaperBossBar((AdventureComponent)plugin.getComponentMessage());
    }

    @Override
    public void loadConfiguration() {
        super.loadConfiguration();
        this.loadInventory("pw-help");
        this.worldEditItems.clear();
        YamlConfiguration configuration = this.getConfiguration();
        List list = configuration.getMapList("items");
        if (list.isEmpty()) {
            return;
        }
        for (Map map : list) {
            TypedMapAccessor accessor = new TypedMapAccessor(map);
            String name = accessor.getString("name");
            String displayName = accessor.getString("display-name", name);
            int maxUse = accessor.getInt("max-use", -1);
            double priceMultiplier = accessor.getDouble("price-multiplier", -1.0);
            Map mapItem = (Map)accessor.getObject("item");
            ZMenuItemStack menuItemStack = MenuItemStackFormMap.fromMap((InventoryManager)this.plugin.getInventoryManager(), (File)new File(this.getFolder(), "config.yml"), (String)name, (Map)mapItem);
            WorldEditItem worldEditItem = new WorldEditItem(name, displayName, maxUse, priceMultiplier, (MenuItemStack)menuItemStack);
            this.worldEditItems.add(worldEditItem);
        }
    }

    @Override
    public Optional<WorldEditItem> getWorldeditItem(String name) {
        return this.worldEditItems.stream().filter(worldEditItem -> worldEditItem.name().equalsIgnoreCase(name)).findFirst();
    }

    @Override
    public void give(CommandSender sender, Player player, String itemName) {
        Optional<WorldEditItem> optional = this.getWorldeditItem(itemName);
        if (optional.isEmpty()) {
            this.message(sender, Message.COMMAND_WORLDEDIT_GIVE_ERROR, "%name%", itemName);
            return;
        }
        WorldEditItem worldeditItem = optional.get();
        ItemStack itemStack = worldeditItem.getItemStack(player, worldeditItem.maxUse());
        this.plugin.give(player, itemStack);
        this.message(sender, Message.COMMAND_WORLDEDIT_GIVE_SENDER, "%player%", player.getName(), "%item%", worldeditItem.displayName());
        this.message((CommandSender)player, Message.COMMAND_WORLDEDIT_GIVE_RECEIVER, "%item%", worldeditItem.displayName());
    }

    @Override
    public List<String> getWorldeditItems() {
        return this.worldEditItems.stream().map(WorldEditItem::name).toList();
    }

    @Override
    public List<String> getAllowedMaterials(Player player) {
        if (player == null) {
            return new ArrayList<String>();
        }
        Set blockMaterials = Stream.of(player.getInventory().getContents()).filter(item -> item != null && item.getType().isBlock()).map(ItemStack::getType).collect(Collectors.toSet());
        blockMaterials.addAll(this.plugin.getVaultManager().getMaterials(player));
        return blockMaterials.stream().filter(material -> material.isBlock() && !this.isBlacklist((Material)material)).map(material -> material.name().toLowerCase()).toList();
    }

    @Override
    public boolean isBlacklist(Material material) {
        return this.blacklistBlocks.contains(material.name());
    }

    private boolean cantUseWorldEdit(User user) {
        Selection selection = user.getSelection();
        if (!selection.isValid()) {
            this.message(user, Message.WORLDEDIT_SELECTION_ERROR, new Object[0]);
            return true;
        }
        int maxBlocks = this.getMaxBlocks(user.getPlayer());
        if (selection.getCuboid().getVolume() > maxBlocks) {
            this.message(user, Message.WORLDEDIT_SELECTION_VOLUME, "%blocks%", maxBlocks);
            return true;
        }
        int maxDistance = this.getMaxDistance(user.getPlayer());
        if (selection.getCuboid().getDistance() > (double)maxDistance) {
            this.message(user, Message.WORLDEDIT_SELECTION_DISTANCE, "%distance%", maxDistance);
            return true;
        }
        if (user.hasWorldeditTask()) {
            this.message(user, Message.WORLDEDIT_ALREADY_RUNNING, new Object[0]);
            return true;
        }
        int speed = this.getBlocksPerSecond(user.getPlayer());
        if (speed <= 0) {
            this.message(user, Message.WORLDEDIT_SPEED_ERROR, new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public void setBlocks(User user, List<MaterialPercent> materialPercents) {
        Selection selection = user.getSelection();
        if (this.cantUseWorldEdit(user)) {
            return;
        }
        SetTask worldEditTask = new SetTask(this.plugin, this, user, selection.getCuboid(), materialPercents);
        this.placeBlock(user, worldEditTask);
    }

    @Override
    public void fillBlocks(User user, List<MaterialPercent> materialPercents) {
        Selection selection = user.getSelection();
        if (this.cantUseWorldEdit(user)) {
            return;
        }
        FillTask worldEditTask = new FillTask(this.plugin, this, user, selection.getCuboid(), materialPercents);
        this.placeBlock(user, worldEditTask);
    }

    @Override
    public void wallsBlocks(User user, List<MaterialPercent> materialPercents) {
        Selection selection = user.getSelection();
        if (this.cantUseWorldEdit(user)) {
            return;
        }
        WallsTask worldEditTask = new WallsTask(this.plugin, this, user, selection.getCuboid(), materialPercents);
        this.placeBlock(user, worldEditTask);
    }

    @Override
    public void sphereBlocks(User user, List<MaterialPercent> materialPercents, int radius, boolean filled) {
        Selection selection = user.getSelection();
        if (this.cantUseWorldEdit(user)) {
            return;
        }
        int maxRadius = this.getSphereRadius(user.getPlayer());
        if (radius > maxRadius) {
            radius = maxRadius;
        }
        SphereTask worldEditTask = new SphereTask(this.plugin, this, user, selection.getCuboid(), materialPercents, radius, filled);
        this.placeBlock(user, worldEditTask);
    }

    @Override
    public void cylBlocks(User user, List<MaterialPercent> materialPercents, int radius, boolean filled, int height) {
        Selection selection = user.getSelection();
        if (this.cantUseWorldEdit(user)) {
            return;
        }
        int maxRadius = this.getSphereRadius(user.getPlayer());
        if (radius > maxRadius) {
            radius = maxRadius;
        }
        CylTask worldEditTask = new CylTask(this.plugin, this, user, selection.getCuboid(), materialPercents, radius, height, filled);
        this.placeBlock(user, worldEditTask);
    }

    private void placeBlock(User user, WorldEditTask worldEditTask) {
        int speed = this.getBlocksPerSecond(user.getPlayer());
        user.setWorldeditTask(worldEditTask);
        ItemStack itemStack = user.getItemInMainHand();
        if (this.isNotWorldeditItem(itemStack)) {
            this.message(user, Message.COMMAND_WORLDEDIT_ERROR_ITEM, new Object[0]);
            return;
        }
        this.message(user, Message.WORLDEDIT_START_CALCULATE_PRICE, new Object[0]);
        worldEditTask.calculatePrice(price -> {
            EconomyManager economyManager = this.plugin.getEconomyManager();
            Economy economy = economyManager.getDefaultEconomy();
            if (!user.has(economy, (BigDecimal)price)) {
                this.message(user, Message.WORLDEDIT_NOT_ENOUGH_MONEY, new Object[0]);
                return;
            }
            int blocks = worldEditTask.count();
            double seconds = (double)blocks / (double)speed;
            String materials = worldEditTask.getMaterials().entrySet().stream().map(entry -> {
                Material material = (Material)entry.getKey();
                Long amount = (Long)entry.getValue();
                BigDecimal blockPrice = this.getMaterialPrice(material);
                return this.getMessage(Message.COMMAND_WORLDEDIT_CONFIRM_MATERIAL, "%translation-key%", material.translationKey(), "%amount%", amount, "%price%", economyManager.format(economy, (Number)blockPrice.multiply(BigDecimal.valueOf(amount))), "%price-per-block%", economyManager.format(economy, (Number)blockPrice));
            }).collect(Collectors.joining(","));
            this.message(user, Message.COMMAND_WORLDEDIT_CONFIRM_PRICE, "%price%", economyManager.format(economy, (Number)price), "%materials%", materials, "%duration%", TimerBuilder.getStringTime(seconds * 1000.0), "%blocks%", blocks, "%speed%", speed, "%s%", speed > 1 ? "s" : "");
        });
    }

    @Override
    public void cutBlocks(User user) {
        Selection selection = user.getSelection();
        int speed = this.getBlocksPerSecond(user.getPlayer());
        if (this.cantUseWorldEdit(user)) {
            return;
        }
        CutTask worldEditTask = new CutTask(this.plugin, this, user, selection.getCuboid());
        user.setWorldeditTask(worldEditTask);
        this.message(user, Message.WORLDEDIT_START_CALCULATE_PRICE, new Object[0]);
        ItemStack itemStack = user.getItemInMainHand();
        if (this.cantUseWorldEditItem(itemStack)) {
            this.message(user, Message.COMMAND_WORLDEDIT_ERROR_MAX, new Object[0]);
            return;
        }
        worldEditTask.calculatePrice(price -> {
            EconomyManager economyManager = this.plugin.getEconomyManager();
            Economy economy = economyManager.getDefaultEconomy();
            if (!user.has(economy, (BigDecimal)price)) {
                this.message(user, Message.WORLDEDIT_NOT_ENOUGH_MONEY, new Object[0]);
                return;
            }
            int blocks = worldEditTask.count();
            double seconds = (double)blocks / (double)speed;
            this.message(user, Message.COMMAND_WORLDEDIT_CONFIRM_PRICE_CUT, "%price%", economyManager.format(economy, (Number)price), "%duration%", TimerBuilder.getStringTime(seconds * 1000.0), "%blocks%", blocks, "%speed%", speed, "%s%", speed > 1 ? "s" : "");
        });
    }

    @Override
    public void confirmAction(User user) {
        if (user.hasWorldeditTask()) {
            this.message(user, Message.WORLDEDIT_ALREADY_RUNNING, new Object[0]);
            return;
        }
        WorldEditTask task = user.getWorldeditTask();
        if (task.getWorldeditStatus() != WorldeditStatus.WAITING_RESPONSE_PRICE) {
            this.message(user, Message.COMMAND_WORLDEDIT_CONFIRM_ERROR, new Object[0]);
            return;
        }
        this.message(user, Message.WORLDEDIT_START_CHECK_INVENTORY, new Object[0]);
        user.getSelection().cancel();
        Economy economy = this.plugin.getEconomyManager().getDefaultEconomy();
        task.confirm(result -> {
            if (result.booleanValue()) {
                if (!user.has(economy, task.getTotalPrice())) {
                    this.message(user, Message.WORLDEDIT_NOT_ENOUGH_MONEY, new Object[0]);
                    return;
                }
                ItemStack itemStack = user.getItemInMainHand();
                if (this.isNotWorldeditItem(itemStack)) {
                    this.message(user, Message.COMMAND_WORLDEDIT_ERROR_ITEM, new Object[0]);
                    return;
                }
                if (this.cantUseWorldEditItem(itemStack)) {
                    this.message(user, Message.COMMAND_WORLDEDIT_ERROR_MAX, new Object[0]);
                    return;
                }
                itemStack = this.useWorldEditItem(user.getPlayer(), itemStack);
                if (itemStack == null) {
                    user.playSound(Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
                    user.setItemInMainHand(new ItemStack(Material.AIR));
                } else {
                    user.setItemInMainHand(itemStack);
                }
                user.withdraw(economy, task.getTotalPrice(), this.withdrawReason);
                this.message(user, Message.WORLDEDIT_START_RUNNING, new Object[0]);
                task.startPlaceBlocks();
            } else {
                this.message(user, Message.WORLDEDIT_NOT_ENOUGH_ITEMS, new Object[0]);
            }
        });
    }

    @Override
    public void stopEdition(User user) {
        WorldEditTask task = user.getWorldeditTask();
        if (task == null) {
            this.message(user, Message.COMMAND_WORLDEDIT_STOP_EMPTY, new Object[0]);
            return;
        }
        if (task.getWorldeditStatus() != WorldeditStatus.RUNNING) {
            this.message(user, Message.COMMAND_WORLDEDIT_STOP_ERROR, new Object[0]);
            return;
        }
        task.cancel(user.getPlayer());
    }

    private boolean isNotWorldeditItem(ItemStack itemStack) {
        if (!itemStack.hasItemMeta()) {
            return true;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer persistentDataContainer = itemMeta.getPersistentDataContainer();
        return !persistentDataContainer.has(WorldEditItem.KEY_WORLDEDIT, PersistentDataType.STRING);
    }

    private ItemStack useWorldEditItem(Player player, ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer persistentDataContainer = itemMeta.getPersistentDataContainer();
        String key = (String)persistentDataContainer.get(WorldEditItem.KEY_WORLDEDIT, PersistentDataType.STRING);
        long use = (Long)persistentDataContainer.getOrDefault(WorldEditItem.KEY_WORLDEDIT_USE, PersistentDataType.LONG, (Object)0L) - 1L;
        Optional<WorldEditItem> optional = this.getWorldeditItem(key);
        if (optional.isEmpty()) {
            return itemStack;
        }
        WorldEditItem worldEditItem = optional.get();
        if (worldEditItem.maxUse() <= 0L) {
            return itemStack;
        }
        if (use < 0L) {
            return null;
        }
        return worldEditItem.getItemStack(player, use);
    }

    private boolean cantUseWorldEditItem(ItemStack itemStack) {
        if (!itemStack.hasItemMeta()) {
            return true;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        PersistentDataContainer persistentDataContainer = itemMeta.getPersistentDataContainer();
        String key = (String)persistentDataContainer.get(WorldEditItem.KEY_WORLDEDIT, PersistentDataType.STRING);
        long use = (Long)persistentDataContainer.getOrDefault(WorldEditItem.KEY_WORLDEDIT_USE, PersistentDataType.LONG, (Object)0L);
        Optional<WorldEditItem> optional = this.getWorldeditItem(key);
        return optional.filter(worldEditItem -> use >= 0L || worldEditItem.maxUse() <= 0L).isEmpty();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInteract(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        ItemStack item = event.getItem();
        if (item == null || block == null || event.useInteractedBlock() == Event.Result.DENY || event.getHand() == EquipmentSlot.OFF_HAND || event.getAction().equals((Object)Action.PHYSICAL) || this.isNotWorldeditItem(item)) {
            return;
        }
        User user = this.getUser((Entity)event.getPlayer());
        if (user == null) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            event.setCancelled(true);
            this.setPos2(event.getPlayer(), block.getLocation());
        } else {
            event.setCancelled(true);
            this.setPos1(event.getPlayer(), block.getLocation());
        }
    }

    @Override
    public void setPos1(Player player, Location location) {
        User user = this.getUser((Entity)player);
        if (user == null) {
            return;
        }
        if (!this.hasPermission(player, location.getBlock())) {
            this.message((CommandSender)player, Message.WORLDEDIT_PERMISSION_ERROR, new Object[0]);
            return;
        }
        Selection selection = user.getSelection();
        selection.setFirstLocation(location);
        this.message((CommandSender)player, Message.WORLDEDIT_SELECTION_POS1, new Object[0]);
    }

    @Override
    public void setPos2(Player player, Location location) {
        User user = this.getUser((Entity)player);
        if (user == null) {
            return;
        }
        if (!this.hasPermission(player, location.getBlock())) {
            this.message((CommandSender)player, Message.WORLDEDIT_PERMISSION_ERROR, new Object[0]);
            return;
        }
        Selection selection = user.getSelection();
        selection.setSecondLocation(location);
        this.message((CommandSender)player, Message.WORLDEDIT_SELECTION_POS2, new Object[0]);
    }

    @Override
    public void toggleOptionInventory(User user) {
        user.setOption(Option.WORLDEDIT_INVENTORY, !user.getOption(Option.WORLDEDIT_INVENTORY));
        this.message(user, user.getOption(Option.WORLDEDIT_INVENTORY) ? Message.COMMAND_WORLDEDIT_OPTION_INVENTORY_ENABLE : Message.COMMAND_WORLDEDIT_OPTION_INVENTORY_DISABLE, new Object[0]);
    }

    @Override
    public void toggleOptionBossBar(User user) {
        user.setOption(Option.WORLDEDIT_BOSSBAR_DISABLE, !user.getOption(Option.WORLDEDIT_BOSSBAR_DISABLE));
        this.message(user, !user.getOption(Option.WORLDEDIT_BOSSBAR_DISABLE) ? Message.COMMAND_WORLDEDIT_OPTION_BOSSBAR_ENABLE : Message.COMMAND_WORLDEDIT_OPTION_BOSSBAR_DISABLE, new Object[0]);
    }

    @Override
    public void cancelSelection(User user) {
        Selection selection = user.getSelection();
        selection.cancel();
        this.message(user, Message.COMMAND_WORLDEDIT_CANCEL, new Object[0]);
    }

    @Override
    public WorldeditBossBar getWorldeditBar() {
        return this.bossBar;
    }

    @Override
    public WorldeditBossBarConfiguration getWorldeditConfiguration() {
        return this.worldeditBossBar;
    }

    @Override
    public BigDecimal getMaterialPrice(Material material) {
        return this.blocksPrice.stream().filter(blockPrice -> blockPrice.material() == material).map(BlockPrice::price).findFirst().orElse(this.defaultBlockPrice);
    }

    @Override
    public int getBlocksPerSecond(Player player) {
        return this.permissionsBlocksPerSecond.stream().filter(permissionBlockPerSecond -> player.hasPermission(permissionBlockPerSecond.permission())).mapToInt(PermissionBlockPerSecond::blocks).max().orElse(0);
    }

    @Override
    public int getMaxBlocks(Player player) {
        return this.permissionsMaxBlocks.stream().filter(permissionMaxBlocks -> player.hasPermission(permissionMaxBlocks.permission())).mapToInt(PermissionMaxBlocks::blocks).max().orElse(0);
    }

    @Override
    public int getMaxDistance(Player player) {
        return this.permissionsMaxDistances.stream().filter(permissionMaxDistance -> player.hasPermission(permissionMaxDistance.permission())).mapToInt(PermissionMaxDistance::distance).max().orElse(0);
    }

    @Override
    public int getSphereRadius(Player player) {
        return this.permissionsSphereRadius.stream().filter(permissionRadius -> player.hasPermission(permissionRadius.permission())).mapToInt(PermissionRadius::radius).max().orElse(0);
    }

    @Override
    public int getCylinderRadius(Player player) {
        return this.permissionsCylinderRadius.stream().filter(permissionRadius -> player.hasPermission(permissionRadius.permission())).mapToInt(PermissionRadius::radius).max().orElse(0);
    }

    @Override
    public int getCylinderHeight(Player player) {
        return this.permissionsCylinderHeight.stream().filter(permissionRadius -> player.hasPermission(permissionRadius.permission())).mapToInt(PermissionHeight::height).max().orElse(0);
    }

    @Override
    public int getSphereHeight(Player player) {
        return this.permissionsSphereHeight.stream().filter(permissionRadius -> player.hasPermission(permissionRadius.permission())).mapToInt(PermissionHeight::height).max().orElse(0);
    }

    @Override
    public void sendFinishMessage(User user) {
        this.message(user, Message.WORLDEDIT_FINISH, new Object[0]);
    }

    @Override
    public void sendRefundMessage(Player player, Map<Material, Long> refundMaterials, BigDecimal refundPrice, Economy economy) {
        EconomyManager economyManager = this.plugin.getEconomyManager();
        String materials = refundMaterials.isEmpty() ? this.getMessage(Message.WORLDEDIT_REFUND_EMPTY, new Object[0]) : refundMaterials.entrySet().stream().map(entry -> {
            Material material = (Material)entry.getKey();
            Long amount = (Long)entry.getValue();
            BigDecimal blockPrice = this.getMaterialPrice(material);
            return this.getMessage(Message.WORLDEDIT_REFUND_MATERIAL, "%translation-key%", material.translationKey(), "%amount%", amount, "%price%", economyManager.format(economy, (Number)blockPrice.multiply(BigDecimal.valueOf(amount))), "%price-per-block%", economyManager.format(economy, (Number)blockPrice));
        }).collect(Collectors.joining(","));
        this.message((CommandSender)player, Message.WORLDEDIT_REFUND, "%materials%", materials, "%price%", economyManager.format(economy, (Number)refundPrice));
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @EventHandler
    public void onQuit(UserQuitEvent event) {
        WorldEditTask task;
        User user = event.getUser();
        Selection selection = user.getSelection();
        if (selection != null) {
            selection.reset();
        }
        if ((task = user.getWorldeditTask()) == null || task.getWorldeditStatus() != WorldeditStatus.RUNNING) {
            return;
        }
        task.cancel(user.getPlayer());
    }

    @Override
    public boolean isOpenHelpInventory() {
        return false;
    }

    @Override
    public String getRefundMessage() {
        return this.refundReason;
    }

    @Override
    public String getWithdrawMessage() {
        return this.withdrawReason;
    }

    @Override
    public boolean hasPermission(Player player, Block block) {
        if (this.blacklistWorlds.contains(block.getWorld().getName())) {
            return false;
        }
        return this.plugin.getPermissions().stream().allMatch(permissionChecker -> permissionChecker.hasPermission(player, block));
    }
}

