/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module.modules.worldedit.bossbar;

import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.utils.component.AdventureComponent;
import fr.maxlego08.essentials.api.worldedit.WorldeditBossBar;
import fr.maxlego08.essentials.api.worldedit.WorldeditBossBarConfiguration;
import fr.maxlego08.essentials.zutils.utils.TimerBuilder;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import org.bukkit.entity.Player;

public class PaperBossBar
extends ZUtils
implements WorldeditBossBar {
    private final AdventureComponent adventureComponent;
    private final Map<UUID, BossBar> bars = new HashMap<UUID, BossBar>();

    public PaperBossBar(AdventureComponent adventureComponent) {
        this.adventureComponent = adventureComponent;
    }

    @Override
    public void create(Player player, WorldeditBossBarConfiguration configuration, long duration) {
        BossBar bossBar = this.adventureComponent.createBossBar(this.getMessage(Message.WORLDEDIT_BOSSBAR, "%time%", TimerBuilder.getStringTime(duration)), BossBar.Color.valueOf((String)configuration.color().toUpperCase()), BossBar.Overlay.valueOf((String)configuration.style().toUpperCase()));
        bossBar.addViewer((Audience)player);
        this.bars.put(player.getUniqueId(), bossBar);
    }

    @Override
    public void update(Player player, float percent, long duration) {
        BossBar bar = this.bars.get(player.getUniqueId());
        if (bar != null) {
            bar.progress(percent);
            bar.name(this.adventureComponent.getComponent(this.getMessage(Message.WORLDEDIT_BOSSBAR, "%time%", TimerBuilder.getStringTime(duration))));
        }
    }

    @Override
    public void remove(Player player) {
        BossBar bar = this.bars.remove(player.getUniqueId());
        if (bar != null) {
            player.hideBossBar(bar);
        }
    }
}

