/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.storage.database.repositeries;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.dto.DiscordAccountDTO;
import fr.maxlego08.essentials.libs.sarah.DatabaseConnection;
import fr.maxlego08.essentials.libs.sarah.database.Schema;
import fr.maxlego08.essentials.storage.database.Repository;
import java.util.Optional;
import java.util.UUID;

public class LinkAccountRepository
extends Repository {
    public LinkAccountRepository(EssentialsPlugin plugin, DatabaseConnection connection) {
        super(plugin, connection, "link_accounts");
    }

    public void insert(UUID uniqueId, String minecraftName, String discordName, long userId) {
        this.insert((Schema table) -> {
            table.uuid("unique_id", uniqueId);
            table.string("minecraft_name", minecraftName);
            table.string("discord_name", discordName);
            table.bigInt("user_id", userId);
        });
    }

    public Optional<DiscordAccountDTO> select(UUID uniqueId) {
        return this.select(DiscordAccountDTO.class, table -> table.where("unique_id", uniqueId)).stream().findFirst();
    }

    public void delete(UUID uniqueId) {
        this.delete((Schema table) -> table.where("unique_id", uniqueId));
    }
}

