/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.storage.storages;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.discord.DiscordAction;
import fr.maxlego08.essentials.api.dto.ChatMessageDTO;
import fr.maxlego08.essentials.api.dto.CommandDTO;
import fr.maxlego08.essentials.api.dto.CooldownDTO;
import fr.maxlego08.essentials.api.dto.DiscordAccountDTO;
import fr.maxlego08.essentials.api.dto.DiscordCodeDTO;
import fr.maxlego08.essentials.api.dto.EconomyDTO;
import fr.maxlego08.essentials.api.dto.EconomyTransactionDTO;
import fr.maxlego08.essentials.api.dto.FlyDTO;
import fr.maxlego08.essentials.api.dto.MailBoxDTO;
import fr.maxlego08.essentials.api.dto.OptionDTO;
import fr.maxlego08.essentials.api.dto.PlayTimeDTO;
import fr.maxlego08.essentials.api.dto.PlayerSlotDTO;
import fr.maxlego08.essentials.api.dto.PowerToolsDTO;
import fr.maxlego08.essentials.api.dto.PrivateMessageDTO;
import fr.maxlego08.essentials.api.dto.SanctionDTO;
import fr.maxlego08.essentials.api.dto.ServerStorageDTO;
import fr.maxlego08.essentials.api.dto.StepDTO;
import fr.maxlego08.essentials.api.dto.UserDTO;
import fr.maxlego08.essentials.api.dto.UserEconomyDTO;
import fr.maxlego08.essentials.api.dto.UserEconomyRankingDTO;
import fr.maxlego08.essentials.api.dto.UserVoteDTO;
import fr.maxlego08.essentials.api.dto.VaultDTO;
import fr.maxlego08.essentials.api.dto.VaultItemDTO;
import fr.maxlego08.essentials.api.economy.Economy;
import fr.maxlego08.essentials.api.economy.PendingEconomyUpdate;
import fr.maxlego08.essentials.api.home.Home;
import fr.maxlego08.essentials.api.mailbox.MailBoxItem;
import fr.maxlego08.essentials.api.sanction.Sanction;
import fr.maxlego08.essentials.api.sanction.SanctionType;
import fr.maxlego08.essentials.api.steps.Step;
import fr.maxlego08.essentials.api.storage.IStorage;
import fr.maxlego08.essentials.api.storage.StorageType;
import fr.maxlego08.essentials.api.user.Option;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.api.user.UserRecord;
import fr.maxlego08.essentials.api.vault.Vault;
import fr.maxlego08.essentials.libs.sarah.DatabaseConfiguration;
import fr.maxlego08.essentials.libs.sarah.DatabaseConnection;
import fr.maxlego08.essentials.libs.sarah.HikariDatabaseConnection;
import fr.maxlego08.essentials.libs.sarah.MigrationManager;
import fr.maxlego08.essentials.libs.sarah.SqliteConnection;
import fr.maxlego08.essentials.libs.sarah.database.DatabaseType;
import fr.maxlego08.essentials.libs.sarah.logger.JULogger;
import fr.maxlego08.essentials.migrations.create.CreateChatMessageMigration;
import fr.maxlego08.essentials.migrations.create.CreateCommandsMigration;
import fr.maxlego08.essentials.migrations.create.CreateEconomyTransactionMigration;
import fr.maxlego08.essentials.migrations.create.CreateLinkAccountMigration;
import fr.maxlego08.essentials.migrations.create.CreateLinkCodeMigrations;
import fr.maxlego08.essentials.migrations.create.CreateLinkHistoryMigration;
import fr.maxlego08.essentials.migrations.create.CreatePlayerSlots;
import fr.maxlego08.essentials.migrations.create.CreatePlayerVault;
import fr.maxlego08.essentials.migrations.create.CreatePlayerVaultItem;
import fr.maxlego08.essentials.migrations.create.CreatePrivateMessagesMigration;
import fr.maxlego08.essentials.migrations.create.CreateSanctionsTableMigration;
import fr.maxlego08.essentials.migrations.create.CreateServerStorageTableMigration;
import fr.maxlego08.essentials.migrations.create.CreateUserCooldownTableMigration;
import fr.maxlego08.essentials.migrations.create.CreateUserEconomyMigration;
import fr.maxlego08.essentials.migrations.create.CreateUserHomeTableMigration;
import fr.maxlego08.essentials.migrations.create.CreateUserMailBoxMigration;
import fr.maxlego08.essentials.migrations.create.CreateUserOptionTableMigration;
import fr.maxlego08.essentials.migrations.create.CreateUserPlayTimeTableMigration;
import fr.maxlego08.essentials.migrations.create.CreateUserPowerToolsMigration;
import fr.maxlego08.essentials.migrations.create.CreateUserPowerToolsV2Migration;
import fr.maxlego08.essentials.migrations.create.CreateUserStepMigration;
import fr.maxlego08.essentials.migrations.create.CreateUserStepV2Migration;
import fr.maxlego08.essentials.migrations.create.CreateUserTableMigration;
import fr.maxlego08.essentials.migrations.create.CreateVoteSiteMigration;
import fr.maxlego08.essentials.migrations.drop.DropPowerToolsMigration;
import fr.maxlego08.essentials.migrations.drop.DropStepMigration;
import fr.maxlego08.essentials.migrations.update.UpdateEconomyTransactionAddColumn;
import fr.maxlego08.essentials.migrations.update.UpdatePlayerSlots;
import fr.maxlego08.essentials.migrations.update.UpdateUserTableAddFlyColumn;
import fr.maxlego08.essentials.migrations.update.UpdateUserTableAddFreezeColumn;
import fr.maxlego08.essentials.migrations.update.UpdateUserTableAddSanctionColumns;
import fr.maxlego08.essentials.migrations.update.UpdateUserTableAddVoteColumn;
import fr.maxlego08.essentials.storage.GlobalDatabaseConfiguration;
import fr.maxlego08.essentials.storage.database.Repositories;
import fr.maxlego08.essentials.storage.database.Repository;
import fr.maxlego08.essentials.storage.database.repositeries.ChatMessagesRepository;
import fr.maxlego08.essentials.storage.database.repositeries.CommandsRepository;
import fr.maxlego08.essentials.storage.database.repositeries.EconomyTransactionsRepository;
import fr.maxlego08.essentials.storage.database.repositeries.LinkAccountRepository;
import fr.maxlego08.essentials.storage.database.repositeries.LinkCodeRepository;
import fr.maxlego08.essentials.storage.database.repositeries.LinkHistoryRepository;
import fr.maxlego08.essentials.storage.database.repositeries.PlayerSlotRepository;
import fr.maxlego08.essentials.storage.database.repositeries.PrivateMessagesRepository;
import fr.maxlego08.essentials.storage.database.repositeries.ServerStorageRepository;
import fr.maxlego08.essentials.storage.database.repositeries.UserCooldownsRepository;
import fr.maxlego08.essentials.storage.database.repositeries.UserEconomyRepository;
import fr.maxlego08.essentials.storage.database.repositeries.UserHomeRepository;
import fr.maxlego08.essentials.storage.database.repositeries.UserMailBoxRepository;
import fr.maxlego08.essentials.storage.database.repositeries.UserOptionRepository;
import fr.maxlego08.essentials.storage.database.repositeries.UserPlayTimeRepository;
import fr.maxlego08.essentials.storage.database.repositeries.UserPowerToolsRepository;
import fr.maxlego08.essentials.storage.database.repositeries.UserRepository;
import fr.maxlego08.essentials.storage.database.repositeries.UserSanctionRepository;
import fr.maxlego08.essentials.storage.database.repositeries.UserStepRepository;
import fr.maxlego08.essentials.storage.database.repositeries.VaultItemRepository;
import fr.maxlego08.essentials.storage.database.repositeries.VaultRepository;
import fr.maxlego08.essentials.storage.database.repositeries.VoteSiteRepository;
import fr.maxlego08.essentials.user.ZUser;
import fr.maxlego08.essentials.zutils.utils.StorageHelper;
import fr.maxlego08.essentials.zutils.utils.TypeSafeCache;
import fr.maxlego08.menu.zcore.utils.nms.ItemStackUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class SqlStorage
extends StorageHelper
implements IStorage {
    private final TypeSafeCache cache = new TypeSafeCache();
    private final DatabaseConnection connection;
    private final Repositories repositories;
    private final Map<String, PendingEconomyUpdate> economyUpdateQueue = new HashMap<String, PendingEconomyUpdate>();

    public SqlStorage(EssentialsPlugin plugin, StorageType storageType) {
        super(plugin);
        DatabaseConfiguration databaseConfiguration = this.getDatabaseConfiguration(plugin, storageType);
        switch (storageType) {
            case SQLITE: {
                DatabaseConnection databaseConnection = new SqliteConnection(databaseConfiguration, plugin.getDataFolder());
                break;
            }
            default: {
                DatabaseConnection databaseConnection = this.connection = new HikariDatabaseConnection(databaseConfiguration);
            }
        }
        if (!this.connection.isValid()) {
            plugin.getLogger().severe("Unable to connect to database !");
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        } else if (storageType == StorageType.SQLITE) {
            plugin.getLogger().info("The database connection is valid ! (SQLITE)");
        } else {
            plugin.getLogger().info("The database connection is valid ! (" + this.connection.getDatabaseConfiguration().getHost() + ")");
        }
        MigrationManager.setMigrationTableName("zessentials_migrations");
        MigrationManager.setDatabaseConfiguration(databaseConfiguration);
        MigrationManager.registerMigration(new CreateUserTableMigration());
        MigrationManager.registerMigration(new CreateServerStorageTableMigration());
        MigrationManager.registerMigration(new CreateUserOptionTableMigration());
        MigrationManager.registerMigration(new CreateUserCooldownTableMigration());
        MigrationManager.registerMigration(new CreateUserEconomyMigration());
        MigrationManager.registerMigration(new CreateEconomyTransactionMigration());
        MigrationManager.registerMigration(new CreateUserHomeTableMigration());
        MigrationManager.registerMigration(new CreateSanctionsTableMigration());
        MigrationManager.registerMigration(new UpdateUserTableAddSanctionColumns());
        MigrationManager.registerMigration(new CreateChatMessageMigration());
        MigrationManager.registerMigration(new CreateCommandsMigration());
        MigrationManager.registerMigration(new CreateUserPlayTimeTableMigration());
        MigrationManager.registerMigration(new CreateUserPowerToolsMigration());
        MigrationManager.registerMigration(new CreateUserMailBoxMigration());
        MigrationManager.registerMigration(new UpdateUserTableAddVoteColumn());
        MigrationManager.registerMigration(new CreateVoteSiteMigration());
        MigrationManager.registerMigration(new CreatePlayerVaultItem());
        MigrationManager.registerMigration(new CreatePlayerVault());
        MigrationManager.registerMigration(new CreatePlayerSlots());
        MigrationManager.registerMigration(new UpdateUserTableAddFreezeColumn());
        MigrationManager.registerMigration(new UpdateUserTableAddFlyColumn());
        MigrationManager.registerMigration(new UpdateEconomyTransactionAddColumn());
        MigrationManager.registerMigration(new CreateLinkCodeMigrations());
        MigrationManager.registerMigration(new CreateLinkAccountMigration());
        MigrationManager.registerMigration(new CreateLinkHistoryMigration());
        MigrationManager.registerMigration(new DropPowerToolsMigration());
        MigrationManager.registerMigration(new CreateUserPowerToolsV2Migration());
        MigrationManager.registerMigration(new UpdatePlayerSlots());
        MigrationManager.registerMigration(new CreatePrivateMessagesMigration());
        MigrationManager.registerMigration(new CreateUserStepMigration());
        MigrationManager.registerMigration(new DropStepMigration());
        MigrationManager.registerMigration(new CreateUserStepV2Migration());
        this.repositories = new Repositories(plugin, this.connection);
        this.repositories.register(UserRepository.class);
        this.repositories.register(UserOptionRepository.class);
        this.repositories.register(UserCooldownsRepository.class);
        this.repositories.register(UserEconomyRepository.class);
        this.repositories.register(EconomyTransactionsRepository.class);
        this.repositories.register(UserHomeRepository.class);
        this.repositories.register(UserSanctionRepository.class);
        this.repositories.register(ChatMessagesRepository.class);
        this.repositories.register(CommandsRepository.class);
        this.repositories.register(UserPlayTimeRepository.class);
        this.repositories.register(UserPowerToolsRepository.class);
        this.repositories.register(UserMailBoxRepository.class);
        this.repositories.register(ServerStorageRepository.class);
        this.repositories.register(VoteSiteRepository.class);
        this.repositories.register(PlayerSlotRepository.class);
        this.repositories.register(VaultItemRepository.class);
        this.repositories.register(VaultRepository.class);
        this.repositories.register(LinkAccountRepository.class);
        this.repositories.register(LinkCodeRepository.class);
        this.repositories.register(LinkHistoryRepository.class);
        this.repositories.register(PrivateMessagesRepository.class);
        this.repositories.register(UserStepRepository.class);
        MigrationManager.execute(this.connection, JULogger.from(this.plugin.getLogger()));
        this.with(UserCooldownsRepository.class).deleteExpiredCooldowns();
        this.with(UserRepository.class).clearExpiredSanctions();
        this.with(UserMailBoxRepository.class).deleteExpiredItems();
        this.setActiveSanctions(this.with(UserSanctionRepository.class).getActiveBan());
        List<ServerStorageDTO> serverStorageDTOS = this.with(ServerStorageRepository.class).select();
        plugin.getServerStorage().setContents(serverStorageDTOS);
        long ms = plugin.getConfiguration().getBatchAutoSave();
        plugin.getScheduler().runTimer(this::processBatchs, ms, ms, TimeUnit.MILLISECONDS);
    }

    public void processBatchs() {
        List<CommandDTO> commands = this.cache.get(CommandDTO.class);
        List<ChatMessageDTO> messages = this.cache.get(ChatMessageDTO.class);
        List<PrivateMessageDTO> privateMessages = this.cache.get(PrivateMessageDTO.class);
        List<EconomyTransactionDTO> transactions = this.cache.get(EconomyTransactionDTO.class);
        List<FlyDTO> flights = this.cache.get(FlyDTO.class);
        this.async(() -> {
            this.with(CommandsRepository.class).insertCommands(commands);
            this.with(ChatMessagesRepository.class).insertMessages(messages);
            this.with(PrivateMessagesRepository.class).insertMessages(privateMessages);
            this.with(EconomyTransactionsRepository.class).insertTransactions(transactions);
            this.with(UserRepository.class).upsertFly(flights);
        });
        this.cache.clearAll();
    }

    @NotNull
    private DatabaseConfiguration getDatabaseConfiguration(EssentialsPlugin plugin, StorageType storageType) {
        GlobalDatabaseConfiguration globalDatabaseConfiguration = new GlobalDatabaseConfiguration(plugin.getConfig());
        String tablePrefix = globalDatabaseConfiguration.getTablePrefix();
        String host = globalDatabaseConfiguration.getHost();
        int port = globalDatabaseConfiguration.getPort();
        String user = globalDatabaseConfiguration.getUser();
        String password = globalDatabaseConfiguration.getPassword();
        String database = globalDatabaseConfiguration.getDatabase();
        boolean debug = globalDatabaseConfiguration.isDebug();
        return new DatabaseConfiguration(tablePrefix, user, password, port, host, database, debug, storageType == StorageType.SQLITE ? DatabaseType.SQLITE : DatabaseType.MYSQL);
    }

    @Override
    public void onEnable() {
        this.connection.connect();
        this.totalUser = this.with(UserRepository.class).totalUsers();
    }

    @Override
    public void onDisable() {
        this.connection.disconnect();
    }

    @Override
    public User createOrLoad(UUID uniqueId, String playerName) {
        ZUser user = new ZUser(this.plugin, uniqueId);
        user.setName(playerName);
        this.users.put(uniqueId, user);
        this.plugin.getScheduler().runAsync(wrappedTask -> {
            Optional optional = this.with(UserRepository.class).selectUser(uniqueId).stream().findFirst();
            if (optional.isEmpty()) {
                this.firstJoin(user);
            }
            this.with(UserRepository.class).upsert(uniqueId, playerName);
            if (optional.isPresent()) {
                SanctionDTO sanction;
                UserDTO userDTO = (UserDTO)optional.get();
                if (userDTO.mute_sanction_id() != null && (sanction = this.with(UserSanctionRepository.class).getSanction(userDTO.mute_sanction_id())).isActive()) {
                    user.setMuteSanction(Sanction.fromDTO(sanction));
                }
                user.setSanction(userDTO.ban_sanction_id(), userDTO.mute_sanction_id());
                user.setWithDTO(userDTO);
                user.setOptions(this.with(UserOptionRepository.class).select(uniqueId));
                user.setCooldowns(this.with(UserCooldownsRepository.class).select(uniqueId));
                user.setEconomies(this.with(UserEconomyRepository.class).select(uniqueId));
                user.setHomes(this.with(UserHomeRepository.class).select(uniqueId));
                user.setPowerTools(this.with(UserPowerToolsRepository.class).select(uniqueId).stream().collect(Collectors.toMap(PowerToolsDTO::material, PowerToolsDTO::command, (a, b) -> b, LinkedHashMap::new)));
                user.setMailBoxItems(this.with(UserMailBoxRepository.class).select(uniqueId));
                user.setVoteSites(this.with(VoteSiteRepository.class).select(uniqueId));
                this.with(LinkAccountRepository.class).select(uniqueId).ifPresent(user::setDiscordAccount);
            }
        });
        return user;
    }

    public <T extends Repository> T with(Class<T> module) {
        return this.repositories.getTable(module);
    }

    @Override
    public void onPlayerQuit(UUID uniqueId) {
        this.users.remove(uniqueId);
    }

    @Override
    public User getUser(UUID uniqueId) {
        return (User)this.users.get(uniqueId);
    }

    @Override
    public void updateOption(UUID uniqueId, Option option, boolean value) {
        this.async(() -> this.with(UserOptionRepository.class).upsert(uniqueId, option, value));
    }

    @Override
    public void updateCooldown(UUID uniqueId, String key, long expiredAt) {
        this.async(() -> this.with(UserCooldownsRepository.class).upsert(uniqueId, key, expiredAt));
    }

    @Override
    public void deleteCooldown(UUID uniqueId, String key) {
        this.async(() -> this.with(UserCooldownsRepository.class).delete(uniqueId, key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateEconomy(UUID uniqueId, Economy economy, BigDecimal bigDecimal) {
        String key = String.valueOf(uniqueId) + ":" + economy.getName();
        Map<String, PendingEconomyUpdate> map = this.economyUpdateQueue;
        synchronized (map) {
            PendingEconomyUpdate pending = this.economyUpdateQueue.get(key);
            if (pending != null) {
                pending.latestValue().set(bigDecimal);
                return;
            }
            PendingEconomyUpdate newPending = new PendingEconomyUpdate(uniqueId, economy, new AtomicReference<BigDecimal>(bigDecimal));
            this.economyUpdateQueue.put(key, newPending);
            this.launchUpdateTask(key, newPending);
        }
    }

    private void launchUpdateTask(String key, PendingEconomyUpdate pending) {
        this.async(() -> {
            while (true) {
                BigDecimal valueToUpdate = pending.latestValue().get();
                this.with(UserEconomyRepository.class).upsert(pending.uniqueId(), pending.economy(), valueToUpdate);
                Map<String, PendingEconomyUpdate> map = this.economyUpdateQueue;
                synchronized (map) {
                    if (pending.latestValue().get().equals(valueToUpdate)) {
                        this.economyUpdateQueue.remove(key);
                        break;
                    }
                }
            }
        });
    }

    @Override
    public void upsertUser(User user) {
        this.async(() -> this.with(UserRepository.class).upsert(user));
    }

    @Override
    public User updateUserMoney(UUID uniqueId) {
        ZUser fakeUser = new ZUser(this.plugin, uniqueId);
        fakeUser.setEconomies(this.with(UserEconomyRepository.class).select(uniqueId));
        return fakeUser;
    }

    @Override
    public void getUserEconomy(String userName, Consumer<List<EconomyDTO>> consumer) {
        this.async(() -> {
            List<EconomyDTO> economyDTOS = this.getLocalEconomyDTO(userName);
            if (!economyDTOS.isEmpty()) {
                consumer.accept(economyDTOS);
                return;
            }
            this.fetchUniqueId(userName, uuid -> {
                if (uuid == null) {
                    consumer.accept(new ArrayList());
                    return;
                }
                consumer.accept(this.with(UserEconomyRepository.class).select((UUID)uuid));
            });
        });
    }

    @Override
    public void fetchUniqueId(String userName, Consumer<UUID> consumer) {
        if (this.localUUIDS.containsKey(userName)) {
            consumer.accept((UUID)this.localUUIDS.get(userName));
            return;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayerIfCached((String)userName);
        if (offlinePlayer != null) {
            this.localUUIDS.put(userName, offlinePlayer.getUniqueId());
            consumer.accept(offlinePlayer.getUniqueId());
            return;
        }
        this.async(() -> this.getLocalUniqueId(userName).ifPresentOrElse(uuid -> {
            this.localUUIDS.put(userName, uuid);
            consumer.accept((UUID)uuid);
        }, () -> {
            List<UserDTO> userDTOS = this.with(UserRepository.class).selectUsers(userName);
            if (userDTOS.isEmpty()) {
                consumer.accept(null);
                return;
            }
            UserDTO userDTO = userDTOS.getFirst();
            this.localUUIDS.put(userName, userDTO.unique_id());
            consumer.accept(userDTO.unique_id());
        }));
    }

    @Override
    public void storeTransactions(UUID fromUuid, UUID toUuid, Economy economy, BigDecimal fromAmount, BigDecimal toAmount, String reason) {
        this.cache.add(new EconomyTransactionDTO(fromUuid, toUuid, economy.getName(), reason, toAmount.subtract(fromAmount), fromAmount, toAmount, new Date(), new Date()));
    }

    @Override
    public List<EconomyTransactionDTO> getTransactions(UUID toUuid, Economy economy) {
        return this.with(EconomyTransactionsRepository.class).selectTransactions(toUuid, economy);
    }

    @Override
    public void upsertStorage(String key, Object value) {
    }

    @Override
    public void upsertHome(UUID uniqueId, Home home) {
        this.async(() -> this.with(UserHomeRepository.class).upsert(uniqueId, home));
    }

    @Override
    public void deleteHome(UUID uniqueId, String name) {
        this.async(() -> this.with(UserHomeRepository.class).deleteHome(uniqueId, name));
    }

    @Override
    public void getHome(UUID uuid, String homeName, Consumer<Optional<Home>> consumer) {
        this.async(() -> consumer.accept(this.with(UserHomeRepository.class).getHomes(uuid, homeName).stream().findFirst()));
    }

    @Override
    public void getHomes(UUID uuid, Consumer<List<Home>> consumer) {
        this.async(() -> consumer.accept(this.with(UserHomeRepository.class).getHomes(uuid)));
    }

    @Override
    public void insertSanction(Sanction sanction, Consumer<Integer> consumer) {
        if (sanction.getSanctionType() == SanctionType.BAN) {
            this.banSanctions.put(sanction.getPlayerUniqueId(), sanction);
        } else if (sanction.getSanctionType() == SanctionType.UNBAN) {
            this.banSanctions.remove(sanction.getPlayerUniqueId());
        }
        this.async(() -> this.with(UserSanctionRepository.class).insert(sanction, consumer));
    }

    @Override
    public void updateUserBan(UUID uuid, Integer index) {
        if (index == null) {
            this.banSanctions.remove(uuid);
        }
        this.async(() -> this.with(UserRepository.class).updateBanId(uuid, index));
    }

    @Override
    public void updateUserMute(UUID uuid, Integer index) {
        this.async(() -> this.with(UserRepository.class).updateMuteId(uuid, index));
    }

    @Override
    public boolean isMute(UUID uuid) {
        Sanction sanction = this.getMute(uuid);
        return sanction != null && sanction.isActive();
    }

    @Override
    public Sanction getMute(UUID uuid) {
        List<UserDTO> userDTOS = this.with(UserRepository.class).selectUser(uuid);
        if (userDTOS.isEmpty()) {
            return null;
        }
        UserDTO userDTO = userDTOS.getFirst();
        if (userDTO.mute_sanction_id() != null) {
            SanctionDTO sanction = this.with(UserSanctionRepository.class).getSanction(userDTO.mute_sanction_id());
            return Sanction.fromDTO(sanction);
        }
        return null;
    }

    @Override
    public List<SanctionDTO> getSanctions(UUID uuid) {
        return this.with(UserSanctionRepository.class).getSanctions(uuid);
    }

    @Override
    public void insertChatMessage(UUID uuid, String content) {
        this.cache.add(new ChatMessageDTO(uuid, content, new Date()));
    }

    @Override
    public void insertPrivateMessage(UUID sender, UUID receiver, String content) {
        this.cache.add(new PrivateMessageDTO(sender, receiver, content, new Date()));
    }

    @Override
    public void insertCommand(UUID uuid, String command) {
        this.cache.add(new CommandDTO(uuid, command, new Date()));
    }

    @Override
    public void insertPlayTime(UUID uniqueId, long sessionPlayTime, long playtime, String address) {
        this.async(() -> {
            if (sessionPlayTime > 0L) {
                this.with(UserPlayTimeRepository.class).insert(uniqueId, sessionPlayTime, address);
            }
            this.with(UserRepository.class).updatePlayTime(uniqueId, playtime);
        });
    }

    @Override
    public List<UserDTO> getUsers(String ip) {
        return this.with(UserRepository.class).getUsers(ip);
    }

    @Override
    public UserRecord fetchUserRecord(UUID uuid) {
        UserDTO userDTO = this.with(UserRepository.class).selectUser(uuid).getFirst();
        List<PlayTimeDTO> playTimeDTOS = this.with(UserPlayTimeRepository.class).select(uuid);
        return new UserRecord(userDTO, playTimeDTOS);
    }

    @Override
    public List<ChatMessageDTO> getMessages(UUID targetUuid) {
        return this.with(ChatMessagesRepository.class).getMessages(targetUuid);
    }

    @Override
    public Map<Option, Boolean> getOptions(UUID uuid) {
        if (this.users.containsKey(uuid)) {
            return ((User)this.users.get(uuid)).getOptions();
        }
        return this.with(UserOptionRepository.class).select(uuid).stream().collect(Collectors.toMap(OptionDTO::option_name, OptionDTO::option_value));
    }

    @Override
    public void getOption(UUID uuid, Option option, Consumer<Boolean> consumer) {
        User user = this.getUser(uuid);
        if (user != null) {
            consumer.accept(user.getOption(option));
        } else {
            this.async(() -> this.with(UserOptionRepository.class).select(uuid, option, consumer));
        }
    }

    @Override
    public List<CooldownDTO> getCooldowns(UUID uniqueId) {
        return this.with(UserCooldownsRepository.class).select(uniqueId);
    }

    @Override
    public void setPowerTools(UUID uniqueId, Material material, String command) {
        this.async(() -> this.with(UserPowerToolsRepository.class).upsert(uniqueId, material, command));
    }

    @Override
    public void deletePowerTools(UUID uniqueId, Material material) {
        this.async(() -> this.with(UserPowerToolsRepository.class).delete(uniqueId, material));
    }

    @Override
    public void addMailBoxItem(MailBoxItem mailBoxItem) {
        this.async(() -> this.with(UserMailBoxRepository.class).insert(mailBoxItem));
    }

    @Override
    public void clearMailBox(UUID uuid) {
        this.async(() -> this.with(UserMailBoxRepository.class).clear(uuid));
    }

    @Override
    public void removeMailBoxItem(int id) {
        this.async(() -> this.with(UserMailBoxRepository.class).delete(id));
    }

    @Override
    public List<UserEconomyRankingDTO> getEconomyRanking(Economy economy) {
        return this.with(UserRepository.class).getBalanceRanking(economy.getName());
    }

    @Override
    public List<MailBoxDTO> getMailBox(UUID uuid) {
        return this.with(UserMailBoxRepository.class).select(uuid);
    }

    @Override
    public void fetchOfflinePlayerEconomies(Consumer<List<UserEconomyDTO>> consumer) {
        this.async(() -> consumer.accept(this.with(UserEconomyRepository.class).getAll()));
    }

    @Override
    public void setVote(UUID uniqueId, long vote, long offline) {
        this.async(() -> this.with(UserRepository.class).setVote(uniqueId, vote, offline));
    }

    @Override
    public UserVoteDTO getVote(UUID uniqueId) {
        User user = this.getUser(uniqueId);
        if (user != null) {
            return new UserVoteDTO(uniqueId, user.getVote(), 0L);
        }
        List<UserVoteDTO> users = this.with(UserRepository.class).selectVoteUser(uniqueId);
        return users.isEmpty() ? new UserVoteDTO(uniqueId, 0L, 0L) : users.getFirst();
    }

    @Override
    public void updateServerStorage(String key, Object object) {
        this.async(() -> this.with(ServerStorageRepository.class).upsert(key, object));
    }

    @Override
    public void setLastVote(UUID uniqueId, String site) {
        this.async(() -> this.with(VoteSiteRepository.class).setLastVote(uniqueId, site));
    }

    @Override
    public void resetVotes() {
        this.async(() -> this.with(UserRepository.class).resetVotes());
    }

    @Override
    public void updateVaultQuantity(UUID uniqueId, int vaultId, int slot, long quantity) {
        this.async(() -> this.with(VaultItemRepository.class).updateQuantity(uniqueId, vaultId, slot, quantity));
    }

    @Override
    public void removeVaultItem(UUID uniqueId, int vaultId, int slot) {
        this.async(() -> this.with(VaultItemRepository.class).removeItem(uniqueId, vaultId, slot));
    }

    @Override
    public void createVaultItem(UUID uniqueId, int vaultId, int slot, long quantity, String item) {
        this.async(() -> this.with(VaultItemRepository.class).createNewItem(uniqueId, vaultId, slot, quantity, item));
    }

    @Override
    public void setVaultSlot(UUID uniqueId, int slots) {
        this.async(() -> this.with(PlayerSlotRepository.class).setSlot(uniqueId, slots));
    }

    @Override
    public List<VaultDTO> getVaults() {
        return this.with(VaultRepository.class).select();
    }

    @Override
    public List<VaultItemDTO> getVaultItems() {
        return this.with(VaultItemRepository.class).select();
    }

    @Override
    public List<PlayerSlotDTO> getPlayerVaultSlots() {
        return this.with(PlayerSlotRepository.class).select();
    }

    @Override
    public void updateVault(UUID uniqueId, Vault vault) {
        this.async(() -> this.with(VaultRepository.class).update(uniqueId, vault.getVaultId(), vault.getName(), vault.getIconItemStack() == null ? null : ItemStackUtils.serializeItemStack((ItemStack)vault.getIconItemStack())));
    }

    @Override
    public void updateUserFrozen(UUID uuid, boolean frozen) {
        this.async(() -> this.with(UserRepository.class).updateFrozen(uuid, frozen));
    }

    @Override
    public void upsertFlySeconds(UUID uniqueId, long flySeconds) {
        this.cache.get(FlyDTO.class).removeIf(e -> e.unique_id().equals(uniqueId));
        this.cache.add(new FlyDTO(uniqueId, flySeconds));
    }

    @Override
    public long getFlySeconds(UUID uniqueId) {
        return this.with(UserRepository.class).selectFly(uniqueId);
    }

    @Override
    public void deleteWorldData(String worldName) {
        this.with(UserRepository.class).deleteWorldData(worldName);
        this.with(UserHomeRepository.class).deleteWorldData(worldName);
    }

    @Override
    public void linkDiscordAccount(UUID uniqueId, String minecraftName, String discordName, long userId) {
        this.async(() -> this.with(LinkAccountRepository.class).insert(uniqueId, minecraftName, discordName, userId));
    }

    @Override
    public Optional<DiscordAccountDTO> selectDiscordAccount(UUID uniqueId) {
        return this.with(LinkAccountRepository.class).select(uniqueId);
    }

    @Override
    public Optional<DiscordCodeDTO> selectCode(String code) {
        return this.with(LinkCodeRepository.class).getCode(code);
    }

    @Override
    public void clearCode(DiscordCodeDTO code) {
        this.with(LinkCodeRepository.class).clearCode(code);
    }

    @Override
    public void insertDiscordLog(DiscordAction action, UUID uniqueId, String minecraftName, String discordName, long userId, String data) {
        this.async(() -> this.with(LinkHistoryRepository.class).insertLog(action, uniqueId, minecraftName, discordName, userId, data));
    }

    @Override
    public void unlinkDiscordAccount(UUID uniqueId) {
        this.async(() -> this.with(LinkAccountRepository.class).delete(uniqueId));
    }

    @Override
    public StepDTO selectStep(UUID uniqueId, Step step) {
        return this.with(UserStepRepository.class).selectStep(uniqueId, step);
    }

    @Override
    public void createStep(UUID uniqueId, Step step, long playTime) {
        this.async(() -> this.with(UserStepRepository.class).createStep(uniqueId, step, playTime));
    }

    @Override
    public void finishStep(UUID uniqueId, Step step, String data, long playTimeEnd, long playTimeBetween) {
        this.async(() -> this.with(UserStepRepository.class).finishStep(uniqueId, step, data, playTimeBetween, playTimeEnd));
    }

    @Override
    public List<String> getPlayerNames() {
        return this.with(UserRepository.class).getPlayerNames();
    }

    public DatabaseConnection getConnection() {
        return this.connection;
    }
}

