/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.user;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.user.TeleportRequest;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.libs.folialib.impl.PlatformScheduler;
import fr.maxlego08.essentials.module.modules.TeleportationModule;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Location;

public class ZTeleportHereRequest
extends ZUtils
implements TeleportRequest {
    private final EssentialsPlugin plugin;
    private final User toUser;
    private final User fromUser;
    private final long expiredAt;
    private boolean isTeleport = false;

    public ZTeleportHereRequest(EssentialsPlugin plugin, User toUser, User fromUser, long expiredAt) {
        this.plugin = plugin;
        this.toUser = toUser;
        this.fromUser = fromUser;
        this.expiredAt = expiredAt;
    }

    @Override
    public User getToUser() {
        return this.toUser;
    }

    @Override
    public User getFromUser() {
        return this.fromUser;
    }

    @Override
    public long getExpiredAt() {
        return this.expiredAt;
    }

    @Override
    public boolean isValid() {
        return this.expiredAt > System.currentTimeMillis() && this.toUser.isOnline() && this.fromUser.isOnline() && !this.isTeleport;
    }

    @Override
    public void accept() {
        this.message(this.fromUser, Message.COMMAND_TPA_HERE_ACCEPT_SENDER, this.toUser);
        this.message(this.toUser, Message.COMMAND_TPA_HERE_ACCEPT_RECEIVER, this.fromUser);
        TeleportationModule teleportationModule = this.plugin.getModuleManager().getModule(TeleportationModule.class);
        AtomicInteger atomicInteger = new AtomicInteger(teleportationModule.getTeleportDelay(this.toUser.getPlayer()));
        if (teleportationModule.isTeleportDelayBypass() && this.toUser.hasPermission(Permission.ESSENTIALS_TELEPORT_BYPASS) || atomicInteger.get() <= 0) {
            this.teleport(teleportationModule);
            return;
        }
        Location playerLocation = this.toUser.getPlayer().getLocation();
        PlatformScheduler serverImplementation = this.plugin.getScheduler();
        serverImplementation.runAtLocationTimer(this.fromUser.getPlayer().getLocation(), wrappedTask -> {
            if (!this.same(playerLocation, this.toUser.getPlayer().getLocation())) {
                this.message(this.toUser, Message.TELEPORT_MOVE, new Object[0]);
                wrappedTask.cancel();
                this.fromUser.removeTeleportRequest(this.toUser);
                return;
            }
            int currentSecond = atomicInteger.getAndDecrement();
            if (!this.toUser.isOnline() || !this.fromUser.isOnline()) {
                wrappedTask.cancel();
                return;
            }
            if (currentSecond <= 0) {
                wrappedTask.cancel();
                this.teleport(teleportationModule);
            } else {
                this.message(this.toUser, Message.TELEPORT_MESSAGE, "%seconds%", currentSecond);
            }
        }, 1L, 20L);
    }

    private void teleport(TeleportationModule teleportationModule) {
        Location location;
        Location playerLocation = this.fromUser.getPlayer().getLocation();
        Location location2 = this.toUser.getPlayer().isFlying() ? playerLocation : (location = teleportationModule.isTeleportSafety() ? this.toSafeLocation(playerLocation) : playerLocation);
        if (teleportationModule.isTeleportToCenter()) {
            location = location.getBlock().getLocation().add(0.5, 0.0, 0.5);
            location.setYaw(playerLocation.getYaw());
            location.setPitch(playerLocation.getPitch());
        }
        this.toUser.teleportNow(location);
        this.toUser.removeTeleportRequest(this.toUser);
        this.message(this.toUser, Message.TELEPORT_SUCCESS, new Object[0]);
        this.isTeleport = true;
    }

    @Override
    public void deny() {
        this.message(this.fromUser, Message.COMMAND_TP_DENY_RECEIVER, this.toUser);
        this.message(this.toUser, Message.COMMAND_TP_DENY_SENDER, this.fromUser);
        this.isTeleport = true;
    }
}

