/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.user.placeholders;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.enchantment.EssentialsEnchantment;
import fr.maxlego08.essentials.api.placeholders.Placeholder;
import fr.maxlego08.essentials.api.placeholders.PlaceholderRegister;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class UserItemsPlaceholders
extends ZUtils
implements PlaceholderRegister {
    @Override
    public void register(Placeholder placeholder, EssentialsPlugin plugin) {
        placeholder.register("iteminhand_maxdurability", player -> {
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            return String.valueOf(itemStack.getType().getMaxDurability());
        }, "Returns the maximum durability of the item in hand");
        placeholder.register("iteminhand_custommodeldata", player -> {
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            if (!itemStack.hasItemMeta()) {
                return "0";
            }
            ItemMeta meta = player.getInventory().getItemInMainHand().getItemMeta();
            return meta != null && meta.hasCustomModelData() ? String.valueOf(meta.getCustomModelData()) : "0";
        }, "Returns the custom model data of the item in hand");
        placeholder.register("iteminhand_displayname", player -> {
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            return itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName() ? itemStack.getItemMeta().getDisplayName() : itemStack.getType().toString();
        }, "Returns the display name of the item in hand");
        placeholder.register("iteminhand_realname", player -> player.getInventory().getItemInMainHand().getType().getKey().getKey(), "Returns the formatted material name of the item in hand");
        placeholder.register("iteminhand_type", player -> player.getInventory().getItemInMainHand().getType().name(), "Returns the material name of the item in hand");
        placeholder.register("iteminhand_amount", player -> {
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            return String.valueOf(itemStack.getAmount());
        }, "Returns the amount of items in the main hand");
        placeholder.register("iteminhand_durability", player -> {
            ItemMeta patt0$temp;
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            if (itemStack.hasItemMeta() && (patt0$temp = itemStack.getItemMeta()) instanceof Damageable) {
                Damageable damageableItem = (Damageable)patt0$temp;
                return String.valueOf(damageableItem.getDamage());
            }
            return "0";
        }, "Returns the amount of durability left of the item in hand");
        placeholder.register("iteminhand_lore", player -> {
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasLore()) {
                return String.join((CharSequence)"\n", itemStack.getItemMeta().getLore());
            }
            return "";
        }, "Returns the lore of the item in hand");
        placeholder.register("iteminhand_enchantments", player -> {
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasEnchants()) {
                ArrayList<CallSite> enchantments = new ArrayList<CallSite>();
                for (Map.Entry entry : itemStack.getItemMeta().getEnchants().entrySet()) {
                    enchantments.add((CallSite)((Object)(((Enchantment)entry.getKey()).getKey().getKey() + ":" + String.valueOf(entry.getValue()))));
                }
                return String.join((CharSequence)", ", enchantments);
            }
            return "";
        }, "Returns the enchantments of the item in hand with their level");
        placeholder.register("iteminhand_hasenchantment_", (player, enchantmentName) -> {
            Optional<EssentialsEnchantment> optional;
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasEnchants() && (optional = plugin.getEnchantments().getEnchantments((String)enchantmentName)).isPresent()) {
                EssentialsEnchantment essentialsEnchantment = optional.get();
                return itemStack.containsEnchantment(essentialsEnchantment.enchantment()) ? "true" : "false";
            }
            return "false";
        }, "Returns true if the item in hand has at least one enchantment", "enchantment");
        placeholder.register("iteminhand_enchantmentlevel_", (player, enchantmentName) -> {
            Optional<EssentialsEnchantment> optional;
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasEnchants() && (optional = plugin.getEnchantments().getEnchantments((String)enchantmentName)).isPresent()) {
                EssentialsEnchantment essentialsEnchantment = optional.get();
                return String.valueOf(itemStack.getEnchantmentLevel(essentialsEnchantment.enchantment()));
            }
            return "0";
        }, "Returns the level of a specific enchantment on the item in hand", "enchantment");
        placeholder.register("iteminhand_itemflags", player -> {
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            if (itemStack.hasItemMeta() && !itemStack.getItemMeta().getItemFlags().isEmpty()) {
                return itemStack.getItemMeta().getItemFlags().stream().map(Enum::name).collect(Collectors.joining(", "));
            }
            return "";
        }, "Returns the itemflags of the item in hand");
        placeholder.register("iteminhand_hasitemflag_", (player, itemFlagName) -> {
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            if (itemStack.hasItemMeta()) {
                return itemStack.getItemMeta().hasItemFlag(ItemFlag.valueOf((String)itemFlagName)) ? "true" : "false";
            }
            return "false";
        }, "Returns true if the item in hand has a specific itemflag", "item flag");
    }
}

