/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.zutils.utils;

import fr.maxlego08.essentials.zutils.utils.LocationUtils;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;

public abstract class PlaceholderUtils
extends LocationUtils {
    private static final ConcurrentHashMap<String, CacheEntry> CACHE = new ConcurrentHashMap();

    protected String papi(String placeHolder, Player player) {
        return PapiHelper.papi(placeHolder, player);
    }

    protected List<String> papi(List<String> placeHolders, Player player) {
        return PapiHelper.papi(placeHolders, player);
    }

    public static class PapiHelper {
        public static String papi(String placeHolder, Player player) {
            if (placeHolder == null) {
                return null;
            }
            if (player == null) {
                return placeHolder;
            }
            if (!placeHolder.contains("%")) {
                return placeHolder;
            }
            String cacheKey = placeHolder + ";" + String.valueOf(player.getUniqueId());
            CacheEntry cachedResult = CACHE.get(cacheKey);
            if (cachedResult != null && cachedResult.isValid()) {
                return cachedResult.value;
            }
            String result = PlaceholderAPI.setPlaceholders((Player)player, (String)placeHolder).replace("%player%", player.getName());
            CACHE.put(cacheKey, new CacheEntry(result, System.currentTimeMillis()));
            return result;
        }

        public static List<String> papi(List<String> placeHolders, Player player) {
            if (player == null) {
                return placeHolders;
            }
            return placeHolders.stream().map(placeHolder -> PapiHelper.papi(placeHolder, player)).collect(Collectors.toList());
        }
    }

    private static class CacheEntry {
        String value;
        long timeStamp;

        public CacheEntry(String value, long timeStamp) {
            this.value = value;
            this.timeStamp = timeStamp;
        }

        public boolean isValid() {
            return System.currentTimeMillis() - this.timeStamp < 100L;
        }
    }
}

