/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.zutils.utils;

import fr.maxlego08.essentials.api.messages.Message;

public class TimerBuilder {
    private static String formatDuration(double totalSeconds) {
        long days = (long)(totalSeconds / 86400.0);
        long hours = (long)(totalSeconds % 86400.0 / 3600.0);
        long minutes = (long)(totalSeconds % 3600.0 / 60.0);
        long seconds = (long)(totalSeconds % 60.0);
        StringBuilder message = new StringBuilder();
        if (days > 0L) {
            message.append(days).append(days <= 1L ? Message.FORMAT_DAY.getMessageAsString() : Message.FORMAT_DAYS.getMessageAsString()).append(" ");
        }
        if (hours > 0L) {
            message.append(hours).append(hours <= 1L ? Message.FORMAT_HOUR.getMessageAsString() : Message.FORMAT_HOURS.getMessageAsString()).append(" ");
        }
        if (minutes > 0L) {
            message.append(minutes).append(minutes <= 1L ? Message.FORMAT_MINUTE.getMessageAsString() : Message.FORMAT_MINUTES.getMessageAsString()).append(" ");
        }
        if (totalSeconds < 10.0) {
            if (totalSeconds == (double)((long)totalSeconds)) {
                long roundedSeconds = (long)totalSeconds;
                message.append(roundedSeconds).append(roundedSeconds <= 1L ? Message.FORMAT_SECOND.getMessageAsString() : Message.FORMAT_SECONDS.getMessageAsString());
            } else {
                message.append(String.format("%.1f", totalSeconds)).append(Message.FORMAT_SECONDS.getMessageAsString());
            }
        } else if (seconds > 0L || message.isEmpty()) {
            message.append(seconds).append(seconds <= 1L ? Message.FORMAT_SECOND.getMessageAsString() : Message.FORMAT_SECONDS.getMessageAsString());
        }
        return TimerBuilder.format(message.toString().trim());
    }

    public static String getStringTime(double milliseconds) {
        return TimerBuilder.formatDuration(milliseconds / 1000.0);
    }

    private static String format(String message) {
        return message.replaceAll(" 0 [a-zA-Z]+(\\s|$)", "");
    }
}

