/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.zutils.utils;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.configuration.NonLoadable;
import fr.maxlego08.essentials.api.modules.Loadable;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class YamlLoader
extends ZUtils {
    protected void loadYamlConfirmation(EssentialsPlugin plugin, YamlConfiguration configuration) {
        for (Field field : this.getClass().getDeclaredFields()) {
            if (field.isAnnotationPresent(NonLoadable.class)) continue;
            field.setAccessible(true);
            try {
                String configKey = field.getName().replaceAll("([A-Z])", "-$1").toLowerCase();
                if (field.getType().equals(Boolean.TYPE) || field.getType().equals(Boolean.class)) {
                    field.setBoolean(this, configuration.getBoolean(configKey));
                    continue;
                }
                if (field.getType().equals(Integer.TYPE) || field.getType().equals(Integer.class)) {
                    field.setInt(this, configuration.getInt(configKey));
                    continue;
                }
                if (field.getType().equals(Long.TYPE) || field.getType().equals(Long.class)) {
                    field.setLong(this, configuration.getLong(configKey));
                    continue;
                }
                if (field.getType().equals(String.class)) {
                    field.set(this, configuration.getString(configKey));
                    continue;
                }
                if (field.getType().equals(Double.TYPE) || field.getType().equals(Double.class)) {
                    field.set(this, configuration.getDouble(configKey));
                    continue;
                }
                if (field.getType().equals(Float.TYPE) || field.getType().equals(Float.class)) {
                    field.set(this, Float.valueOf((float)configuration.getDouble(configKey)));
                    continue;
                }
                if (field.getType().equals(BigDecimal.class)) {
                    field.set(this, new BigDecimal(configuration.getString(configKey, "0")));
                    continue;
                }
                if (field.getType().isEnum()) {
                    Class<?> enumType = field.getType();
                    field.set(this, Enum.valueOf(enumType, configuration.getString(configKey, "").toUpperCase()));
                    continue;
                }
                if (field.getType().equals(List.class)) {
                    Type genericFieldType = field.getGenericType();
                    if (genericFieldType instanceof ParameterizedType) {
                        ParameterizedType type = (ParameterizedType)genericFieldType;
                        Class fieldArgClass = (Class)type.getActualTypeArguments()[0];
                        if (Loadable.class.isAssignableFrom(fieldArgClass)) {
                            field.set(this, this.loadObjects(plugin.getLogger(), fieldArgClass, configuration.getMapList(configKey)));
                            continue;
                        }
                        if (NonLoadable.class.isAssignableFrom(fieldArgClass)) continue;
                    }
                    field.set(this, configuration.getStringList(configKey));
                    continue;
                }
                ConfigurationSection configurationSection = configuration.getConfigurationSection(configKey);
                if (configurationSection == null) continue;
                HashMap map = new HashMap();
                configurationSection.getKeys(false).forEach(key -> map.put(key, configurationSection.get(key)));
                field.set(this, this.createInstanceFromMap(plugin.getLogger(), ((Class)field.getGenericType()).getConstructors()[0], map));
            }
            catch (Exception exception) {
                plugin.getLogger().severe("An error with loading field " + field.getName() + ": " + exception.getMessage());
            }
        }
    }

    private List<Object> loadObjects(Logger logger, Class<?> fieldArgClass, List<Map<?, ?>> maps) {
        Constructor<?> constructor = fieldArgClass.getConstructors()[0];
        return maps.stream().map(map -> this.createInstanceFromMap(logger, constructor, (Map<?, ?>)map)).collect(Collectors.toList());
    }
}

