/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.zutils.utils.commands;

import fr.maxlego08.essentials.api.Configuration;
import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.EssentialsCommand;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.commands.Tab;
import fr.maxlego08.essentials.api.commands.TabCompletion;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.modules.Module;
import fr.maxlego08.essentials.api.user.Option;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.zutils.utils.TimerBuilder;
import fr.maxlego08.essentials.zutils.utils.commands.Arguments;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public abstract class VCommand
extends Arguments
implements EssentialsCommand {
    private static final Map<String, List<Consumer<UUID>>> uuidRequestQueue = new HashMap<String, List<Consumer<UUID>>>();
    protected final EssentialsPlugin plugin;
    protected final List<String> cooldowns = Arrays.asList("1m", "5m", "10m", "30m", "1h", "2h", "3h", "4h", "5h", "6h", "7h", "8h", "9h", "10h", "11h", "12h", "13h", "14h", "15h", "1d", "2d", "3d", "4d", "5d", "6d", "7d", "14d", "21d", "28d", "30d");
    protected final List<VCommand> subVCommands = new ArrayList<VCommand>();
    private final List<String> subCommands = new ArrayList<String>();
    private final List<String> requireArgs = new ArrayList<String>();
    private final List<String> optionalArgs = new ArrayList<String>();
    private final Map<Integer, TabCompletion> tabCompletions = new HashMap<Integer, TabCompletion>();
    protected VCommand parent;
    protected CommandSender sender;
    protected Player player;
    protected User user;
    protected Configuration configuration;
    protected Class<? extends Module> module;
    private boolean consoleCanUse = true;
    private boolean ignoreParent = false;
    private boolean ignoreArgs = false;
    private String permission;
    private String syntax;
    private String description;
    private int argsMinLength;
    private int argsMaxLength;
    private boolean extendedArgs = false;
    private CommandResultType tabCompleter = CommandResultType.DEFAULT;

    public VCommand(EssentialsPlugin plugin) {
        this.plugin = plugin;
    }

    public void setModule(Class<? extends Module> module) {
        this.module = module;
    }

    public boolean isExtendedArgs() {
        return this.extendedArgs;
    }

    public void setExtendedArgs(boolean extendedArgs) {
        this.extendedArgs = extendedArgs;
    }

    public EssentialsPlugin getPlugin() {
        return this.plugin;
    }

    public List<VCommand> getSubVCommands() {
        return this.subVCommands;
    }

    @Override
    public List<EssentialsCommand> getSubEssentialsCommands() {
        return this.subVCommands.stream().map(e -> e).toList();
    }

    @Override
    public List<String> getSubCommands() {
        return this.subCommands;
    }

    public List<String> getRequireArgs() {
        return this.requireArgs;
    }

    public List<String> getOptionalArgs() {
        return this.optionalArgs;
    }

    public Map<Integer, TabCompletion> getTabCompletions() {
        return this.tabCompletions;
    }

    @Override
    public VCommand getParent() {
        return this.parent;
    }

    public void setParent(VCommand parent) {
        this.parent = parent;
    }

    @Override
    public EssentialsCommand getMainParent() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getParent() == null) {
            return this.parent;
        }
        return this.parent.getMainParent();
    }

    protected User getUser(Player player) {
        return this.plugin.getStorageManager().getStorage().getUser(player.getUniqueId());
    }

    @Override
    public String getPermission() {
        return this.permission;
    }

    @Override
    public void setPermission(String permission) {
        this.permission = permission;
    }

    public void setPermission(Permission permission) {
        this.permission = permission.asPermission();
    }

    @Override
    public String getSyntax() {
        return this.syntax == null ? (this.syntax = this.generateDefaultSyntax("")) : this.syntax;
    }

    public void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDescription(Message description) {
        this.description = description.getMessageAsString();
    }

    public int getArgsMinLength() {
        return this.argsMinLength;
    }

    public void setArgsMinLength(int argsMinLength) {
        this.argsMinLength = argsMinLength;
    }

    public int getArgsMaxLength() {
        return this.argsMaxLength;
    }

    public void setArgsMaxLength(int argsMaxLength) {
        this.argsMaxLength = argsMaxLength;
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public void setSender(CommandSender sender) {
        this.sender = sender;
    }

    protected void setTabCompleter() {
        this.tabCompleter = CommandResultType.SUCCESS;
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    public boolean isIgnoreParent() {
        return this.ignoreParent;
    }

    public void setIgnoreParent(boolean ignoreParent) {
        this.ignoreParent = ignoreParent;
    }

    @Override
    public boolean isIgnoreArgs() {
        return this.ignoreArgs;
    }

    public void setIgnoreArgs(boolean ignoreArgs) {
        this.ignoreArgs = ignoreArgs;
    }

    protected void onlyPlayers() {
        this.consoleCanUse = false;
    }

    @Override
    public CommandResultType getTabCompleter() {
        return this.tabCompleter;
    }

    public void setTabCompleter(CommandResultType tabCompleter) {
        this.tabCompleter = tabCompleter;
    }

    public Optional<TabCompletion> getCompletionAt(int index) {
        return Optional.ofNullable(this.tabCompletions.getOrDefault(index, null));
    }

    protected void addRequireArg(String message) {
        this.requireArgs.add(message);
        this.ignoreParent = this.parent == null;
        this.ignoreArgs = true;
    }

    protected void addRequirePlayerNameArg() {
        this.addRequireArg("player", this.getOnlinePlayers());
    }

    protected void addRequireOfflinePlayerNameArg() {
        this.addRequireArg("player", this.getOfflinePlayers());
    }

    protected void addOptionalOfflinePlayerNameArg() {
        this.addOptionalArg("player", this.getOfflinePlayers());
    }

    protected void addRequireArg(String message, TabCompletion runnable) {
        this.addRequireArg(message);
        int index = this.requireArgs.size();
        this.addCompletion(index - 1, runnable);
    }

    protected TabCompletion getOnlinePlayers() {
        return (a, b) -> this.plugin.getEssentialsServer().getPlayersNames();
    }

    protected TabCompletion getOfflinePlayers() {
        return (a, b) -> this.plugin.getEssentialsServer().getOfflinePlayersNames();
    }

    protected void addOptionalArg(String message) {
        this.optionalArgs.add(message);
        this.ignoreParent = this.parent == null;
        this.ignoreArgs = true;
    }

    protected void addBooleanOptionalArg(String message) {
        this.addOptionalArg(message);
        int index = this.requireArgs.size() + this.optionalArgs.size();
        this.addCompletion(index - 1, (a, b) -> Arrays.asList("true", "false"));
    }

    protected void addOptionalArg(String message, TabCompletion runnable) {
        this.addOptionalArg(message);
        int index = this.requireArgs.size() + this.optionalArgs.size();
        this.addCompletion(index - 1, runnable);
    }

    private String generateDefaultSyntax(String syntax) {
        boolean update = syntax.isEmpty();
        StringBuilder syntaxBuilder = new StringBuilder();
        if (update) {
            this.appendRequiredArguments(syntaxBuilder);
            this.appendOptionalArguments(syntaxBuilder);
            syntax = syntaxBuilder.toString();
        }
        String tmpString = this.subCommands.get(0) + syntax;
        return this.parent == null ? "/" + tmpString : this.parent.generateDefaultSyntax(" " + tmpString);
    }

    private void appendRequiredArguments(StringBuilder syntaxBuilder) {
        this.requireArgs.forEach(arg -> syntaxBuilder.append(" <").append((String)arg).append(">"));
    }

    private void appendOptionalArguments(StringBuilder syntaxBuilder) {
        this.optionalArgs.forEach(arg -> syntaxBuilder.append(" [<").append((String)arg).append(">]"));
    }

    private int parentCount(int defaultParent) {
        return this.parent == null ? defaultParent : this.parent.parentCount(defaultParent + 1);
    }

    @Override
    public boolean isConsoleCanUse() {
        return this.consoleCanUse;
    }

    protected boolean isPlayer() {
        return this.player != null;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    @Override
    public void addSubCommand(String subCommand) {
        this.subCommands.add(subCommand);
    }

    public VCommand addSubCommand(VCommand command) {
        command.setParent(this);
        this.plugin.getCommandManager().registerCommand(command);
        this.subVCommands.add(command);
        return this;
    }

    public VCommand addSubCommand(String ... subCommand) {
        this.subCommands.addAll(Arrays.asList(subCommand));
        return this;
    }

    protected void addCompletion(int index, TabCompletion runnable) {
        this.tabCompletions.put(index, runnable);
        this.setTabCompleter();
    }

    @Override
    public String getMainCommand() {
        return this.subCommands.get(0);
    }

    @Override
    public void addSubCommand(List<String> aliases) {
        this.subCommands.addAll(aliases);
    }

    @Override
    public CommandResultType prePerform(EssentialsPlugin plugin, CommandSender commandSender, String[] args) {
        this.updateArgumentCounts();
        if (this.syntax == null) {
            this.syntax = this.generateDefaultSyntax("");
        }
        this.args = args;
        if (this.isSubCommandMatch()) {
            return CommandResultType.CONTINUE;
        }
        if (this.isSyntaxError(args.length)) {
            return CommandResultType.SYNTAX_ERROR;
        }
        this.sender = commandSender;
        this.setPlayerIfApplicable();
        return this.safelyPerformCommand(plugin);
    }

    private void updateArgumentCounts() {
        this.parentCount = this.parentCount(0);
        this.argsMaxLength = this.requireArgs.size() + this.optionalArgs.size() + this.parentCount;
        this.argsMinLength = this.requireArgs.size() + this.parentCount;
    }

    private boolean isSubCommandMatch() {
        String defaultString = super.argAsString(0);
        if (defaultString != null) {
            for (VCommand subCommand : this.subVCommands) {
                if (!subCommand.getSubCommands().contains(defaultString.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSyntaxError(int argsLength) {
        return this.argsMinLength != 0 && argsLength < this.argsMinLength || this.argsMaxLength != 0 && argsLength > this.argsMaxLength && !this.extendedArgs;
    }

    private void setPlayerIfApplicable() {
        CommandSender commandSender = this.sender;
        if (commandSender instanceof Player) {
            Player player;
            this.player = player = (Player)commandSender;
            this.user = this.plugin.getStorageManager().getStorage().getUser(player.getUniqueId());
        } else {
            this.player = null;
            this.user = null;
        }
    }

    private CommandResultType safelyPerformCommand(EssentialsPlugin plugin) {
        try {
            Module module;
            Optional<Integer> optional;
            int cooldownSeconds = 0;
            String key = this.getMainCommand();
            this.configuration = this.plugin.getConfiguration();
            if (!(this.user == null || this.user.hasPermission(Permission.ESSENTIALS_BYPASS_COOLDOWN) && this.configuration.isEnableCooldownBypass() || !(optional = this.configuration.getCooldown((Permissible)this.sender, key)).isPresent())) {
                cooldownSeconds = optional.get();
                if (this.user.isCooldown(key)) {
                    long milliSeconds = this.user.getCooldown(key) - System.currentTimeMillis();
                    this.message(this.sender, Message.COOLDOWN, "%cooldown%", TimerBuilder.getStringTime(milliSeconds));
                    return CommandResultType.COOLDOWN;
                }
            }
            if (this.module != null && !(module = this.plugin.getModuleManager().getModule(this.module)).isEnable()) {
                this.message(this.sender, Message.MODULE_DISABLE, "%name%", module.getName());
                return CommandResultType.MODULE_DISABLE;
            }
            CommandResultType commandResultType = this.perform(plugin);
            if (!(commandResultType != CommandResultType.SUCCESS || cooldownSeconds == 0 || this.user == null || this.user.hasPermission(Permission.ESSENTIALS_BYPASS_COOLDOWN) && this.configuration.isEnableCooldownBypass())) {
                this.user.addCooldown(key, cooldownSeconds);
            }
            return commandResultType;
        }
        catch (Exception exception) {
            if (plugin.getConfiguration().isEnableDebug()) {
                exception.printStackTrace();
            }
            return CommandResultType.SYNTAX_ERROR;
        }
    }

    protected abstract CommandResultType perform(EssentialsPlugin var1);

    public boolean sameSubCommands() {
        if (this.parent == null) {
            return false;
        }
        for (String command : this.subCommands) {
            if (!this.parent.getSubCommands().contains(command)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> toTab(EssentialsPlugin plugin, CommandSender sender, String[] args) {
        this.parentCount = this.parentCount(0);
        int currentIndex = args.length - this.parentCount - 1;
        Optional<TabCompletion> optional = this.getCompletionAt(currentIndex);
        if (optional.isPresent()) {
            TabCompletion collectionRunnable = optional.get();
            String startWith = args[args.length - 1];
            return this.generateList(collectionRunnable.accept(sender, args), startWith);
        }
        return null;
    }

    protected List<String> generateList(List<String> defaultList, String startWith) {
        return this.generateList(defaultList, startWith, Tab.CONTAINS);
    }

    protected List<String> generateList(List<String> defaultList, String startWith, Tab tab) {
        ArrayList<String> generatedList = new ArrayList<String>();
        for (String str : defaultList) {
            if (str == null || !startWith.isEmpty() && !(tab.equals((Object)Tab.START) ? str.toLowerCase().startsWith(startWith.toLowerCase()) : str.toLowerCase().contains(startWith.toLowerCase()))) continue;
            generatedList.add(str);
        }
        return generatedList.isEmpty() ? null : generatedList;
    }

    public void syntaxMessage() {
        ArrayList<VCommand> commands = new ArrayList<VCommand>(this.subVCommands);
        commands.sort(new VCommandComparator());
        commands.forEach(command -> {
            if (command.getPermission() == null || this.sender.hasPermission(command.getPermission())) {
                this.message(this.sender, Message.COMMAND_SYNTAXE_HELP, "%syntax%", command.getSyntax(), "%description%", command.getDescription());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void fetchUniqueId(String userName, Consumer<UUID> consumer) {
        CommandSender commandSender = this.sender;
        Map<String, List<Consumer<UUID>>> map = uuidRequestQueue;
        synchronized (map) {
            if (uuidRequestQueue.containsKey(userName)) {
                uuidRequestQueue.get(userName).add(consumer);
                return;
            }
            ArrayList<Consumer<UUID>> consumers = new ArrayList<Consumer<UUID>>();
            consumers.add(consumer);
            uuidRequestQueue.put(userName, consumers);
        }
        this.plugin.getStorageManager().getStorage().fetchUniqueId(userName, uuid -> {
            List<Consumer<UUID>> consumers;
            Map<String, List<Consumer<UUID>>> map = uuidRequestQueue;
            synchronized (map) {
                consumers = uuidRequestQueue.remove(userName);
            }
            if (uuid == null) {
                this.message(commandSender, Message.PLAYER_NOT_FOUND, "%player%", userName);
                return;
            }
            for (Consumer consumer : consumers) {
                consumer.accept(uuid);
            }
        });
    }

    protected void checkOption(UUID uuid, Option option, Consumer<Boolean> consumer) {
        this.plugin.getStorageManager().getStorage().getOption(uuid, option, consumer);
    }

    protected void isOnline(String userName, Runnable runnable) {
        CommandSender commandSender = this.sender;
        this.plugin.getScheduler().runAsync(wrappedTask -> {
            if (!this.plugin.getEssentialsServer().isOnline(userName)) {
                this.message(commandSender, Message.PLAYER_NOT_FOUND, "%player%", userName);
                return;
            }
            runnable.run();
        });
    }

    protected String getArgs(int start) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = start; i < this.args.length; ++i) {
            if (i != start) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(this.args[i]);
        }
        return stringBuilder.toString();
    }

    protected String getArgs(int start, String defaultValue) {
        String result = this.getArgs(start);
        return result.isEmpty() ? defaultValue : result;
    }

    private static class VCommandComparator
    implements Comparator<VCommand> {
        private VCommandComparator() {
        }

        @Override
        public int compare(VCommand command1, VCommand command2) {
            return command1.getMainCommand().compareTo(command2.getMainCommand());
        }
    }
}

