/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.zutils.utils.component.components;

import fr.maxlego08.essentials.zutils.utils.component.AbstractComponent;
import fr.maxlego08.essentials.zutils.utils.component.components.ClickEvent;
import fr.maxlego08.essentials.zutils.utils.component.components.HoverEvent;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public final class TextComponent
extends AbstractComponent {
    public boolean forceUnItalic;
    private String text;
    private String color;
    private boolean bold;
    private boolean italic;
    private boolean underlined;
    private boolean strikethrough;
    private boolean obfuscated;
    private String insertion;
    private ClickEvent clickEvent;
    private HoverEvent hoverEvent;

    public TextComponent(String text, String color, boolean bold, boolean italic, boolean underlined, boolean strikethrough, boolean obfuscated, boolean forceUnItalic, String insertion, ClickEvent clickEvent, HoverEvent hoverEvent) {
        this.text = text;
        this.color = color;
        this.bold = bold;
        this.italic = italic;
        this.underlined = underlined;
        this.strikethrough = strikethrough;
        this.obfuscated = obfuscated;
        this.forceUnItalic = forceUnItalic;
        this.insertion = insertion;
        this.clickEvent = clickEvent;
        this.hoverEvent = hoverEvent;
    }

    public TextComponent(String text) {
        this.text = text;
    }

    public TextComponent() {
    }

    public TextComponent(net.kyori.adventure.text.TextComponent component) {
        net.kyori.adventure.text.event.HoverEvent hoverEvent;
        this.text = component.content();
        TextColor color = component.color();
        if (color != null) {
            this.color = color.asHexString();
        }
        this.bold = component.style().hasDecoration(TextDecoration.BOLD);
        this.italic = component.style().hasDecoration(TextDecoration.ITALIC);
        this.underlined = component.style().hasDecoration(TextDecoration.UNDERLINED);
        this.strikethrough = component.style().hasDecoration(TextDecoration.STRIKETHROUGH);
        this.obfuscated = component.style().hasDecoration(TextDecoration.OBFUSCATED);
        this.insertion = component.insertion();
        net.kyori.adventure.text.event.ClickEvent clickEvent = component.clickEvent();
        if (clickEvent != null) {
            this.clickEvent = new ClickEvent(clickEvent);
        }
        if ((hoverEvent = component.hoverEvent()) != null) {
            this.hoverEvent = new HoverEvent(hoverEvent);
        }
        if (!component.children().isEmpty()) {
            for (Component child : component.children()) {
                this.extra.add(AbstractComponent.parse(child));
            }
        }
    }

    @Override
    public String toMiniMessage() {
        StringBuilder builder = new StringBuilder();
        this.appendTag(builder, this.color, () -> "<" + this.color + ">");
        this.appendTag(builder, this.bold, "<bold>");
        this.appendTag(builder, this.italic, "<italic>");
        this.appendTag(builder, this.forceUnItalic, "<!italic>");
        this.appendTag(builder, this.underlined, "<underlined>");
        this.appendTag(builder, this.strikethrough, "<strikethrough>");
        this.appendTag(builder, this.obfuscated, "<obfuscated>");
        this.appendTag(builder, this.insertion, () -> "<insert:" + this.insertion + ">");
        this.appendTag(builder, this.clickEvent, () -> this.clickEvent.toMiniMessage());
        this.appendTag(builder, this.hoverEvent, () -> this.hoverEvent.toMiniMessage());
        this.appendTag(builder, this.text != null && !this.text.isEmpty(), this.text);
        for (AbstractComponent component : this.extra) {
            builder.append(component.toMiniMessage());
        }
        this.appendClosingTag(builder, this.hoverEvent, "</hover>");
        this.appendClosingTag(builder, this.clickEvent, "</click>");
        this.appendClosingTag(builder, this.insertion, "</insert>");
        this.appendClosingTag(builder, this.obfuscated, "</obfuscated>");
        this.appendClosingTag(builder, this.strikethrough, "</strikethrough>");
        this.appendClosingTag(builder, this.underlined, "</underlined>");
        this.appendClosingTag(builder, this.italic, "</italic>");
        this.appendClosingTag(builder, this.forceUnItalic, "</!italic>");
        this.appendClosingTag(builder, this.bold, "</bold>");
        this.appendClosingTag(builder, this.color, "</" + this.color + ">");
        return builder.toString();
    }

    private void appendTag(StringBuilder builder, Object value, Supplier<String> tagSupplier) {
        if (value != null) {
            builder.append(tagSupplier.get());
        }
    }

    private void appendTag(StringBuilder builder, boolean condition, String tag) {
        if (condition) {
            builder.append(tag);
        }
    }

    private void appendClosingTag(StringBuilder builder, boolean condition, String tag) {
        if (condition) {
            builder.append(tag);
        }
    }

    private void appendClosingTag(StringBuilder builder, Object value, String tag) {
        if (value != null) {
            builder.append(tag);
        }
    }

    public String getText() {
        return this.text;
    }

    public String getColor() {
        return this.color;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public boolean isStrikethrough() {
        return this.strikethrough;
    }

    public boolean isObfuscated() {
        return this.obfuscated;
    }

    public boolean isForceUnItalic() {
        return this.forceUnItalic;
    }

    public String getInsertion() {
        return this.insertion;
    }

    public ClickEvent getClickEvent() {
        return this.clickEvent;
    }

    public HoverEvent getHoverEvent() {
        return this.hoverEvent;
    }
}

