/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.zutils.utils.documentation;

import fr.maxlego08.essentials.zutils.utils.documentation.PermissionInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;

public class PermissionMarkdownGenerator {
    public void generateMarkdownFile(List<PermissionInfo> permissions, Path filePath) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("| Permission | Description |\n");
        sb.append("|--------------|-------------|\n");
        permissions.sort(Comparator.comparing(PermissionInfo::permission));
        for (PermissionInfo permissionInfo : permissions) {
            String placeholderText = permissionInfo.permission();
            String desc = permissionInfo.description();
            sb.append(String.format("| `%s` | %s |\n", placeholderText, desc));
        }
        Files.writeString(filePath, (CharSequence)sb.toString(), new OpenOption[0]);
    }
}

