/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.zutils.utils.documentation;

import fr.maxlego08.essentials.placeholders.AutoPlaceholder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class PlaceholderMarkdownGenerator {
    public void generateMarkdownFile(List<AutoPlaceholder> placeholders, Path filePath) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("| Placeholder | Description |\n");
        sb.append("|--------------|-------------|\n");
        placeholders.sort(Comparator.comparing(AutoPlaceholder::getStartWith));
        for (AutoPlaceholder placeholder : placeholders) {
            String placeholderText = "%zessentials_" + placeholder.getStartWith();
            if (!placeholder.getArgs().isEmpty()) {
                String args = placeholder.getArgs().stream().map(argument -> "<" + argument + ">").collect(Collectors.joining("_"));
                placeholderText = placeholderText + args;
            }
            placeholderText = placeholderText + "%";
            String desc = placeholder.getDescription().replace("|", "\\|");
            sb.append(String.format("| `%s` | %s |\n", placeholderText, desc));
        }
        Files.writeString(filePath, (CharSequence)sb.toString(), new OpenOption[0]);
    }
}

