/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.DefaultJedisSocketFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisSocketFactory;
import redis.clients.jedis.exceptions.JedisException;

public class ConnectionFactory
implements PooledObjectFactory<Connection> {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionFactory.class);
    private final JedisSocketFactory jedisSocketFactory;
    private final JedisClientConfig clientConfig;

    public ConnectionFactory(HostAndPort hostAndPort) {
        this.clientConfig = DefaultJedisClientConfig.builder().build();
        this.jedisSocketFactory = new DefaultJedisSocketFactory(hostAndPort);
    }

    public ConnectionFactory(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this.clientConfig = DefaultJedisClientConfig.copyConfig(clientConfig);
        this.jedisSocketFactory = new DefaultJedisSocketFactory(hostAndPort, this.clientConfig);
    }

    public ConnectionFactory(JedisSocketFactory jedisSocketFactory, JedisClientConfig clientConfig) {
        this.clientConfig = DefaultJedisClientConfig.copyConfig(clientConfig);
        this.jedisSocketFactory = jedisSocketFactory;
    }

    public void setPassword(String password) {
        this.clientConfig.updatePassword(password);
    }

    @Override
    public void activateObject(PooledObject<Connection> pooledConnection) throws Exception {
    }

    @Override
    public void destroyObject(PooledObject<Connection> pooledConnection) throws Exception {
        Connection jedis = pooledConnection.getObject();
        if (jedis.isConnected()) {
            try {
                if (!jedis.isBroken()) {
                    jedis.quit();
                }
            }
            catch (RuntimeException e) {
                logger.debug("Error while QUIT", e);
            }
            try {
                jedis.close();
            }
            catch (RuntimeException e) {
                logger.debug("Error while close", e);
            }
        }
    }

    @Override
    public PooledObject<Connection> makeObject() throws Exception {
        Connection jedis = null;
        try {
            jedis = new Connection(this.jedisSocketFactory, this.clientConfig);
            jedis.connect();
            return new DefaultPooledObject<Connection>(jedis);
        }
        catch (JedisException je) {
            if (jedis != null) {
                try {
                    jedis.quit();
                }
                catch (RuntimeException e) {
                    logger.debug("Error while QUIT", e);
                }
                try {
                    jedis.close();
                }
                catch (RuntimeException e) {
                    logger.debug("Error while close", e);
                }
            }
            throw je;
        }
    }

    @Override
    public void passivateObject(PooledObject<Connection> pooledConnection) throws Exception {
    }

    @Override
    public boolean validateObject(PooledObject<Connection> pooledConnection) {
        Connection jedis = pooledConnection.getObject();
        try {
            return jedis.isConnected() && jedis.ping();
        }
        catch (Exception e) {
            logger.error("Error while validating pooled Connection object.", e);
            return false;
        }
    }
}

