/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.search.FieldName;

public class Schema {
    @Deprecated
    public final List<Field> fields = new ArrayList<Field>();

    public static Schema from(Field ... fields) {
        Schema schema = new Schema();
        for (Field field : fields) {
            schema.addField(field);
        }
        return schema;
    }

    public Schema addTextField(String name, double weight) {
        this.fields.add(new TextField(name, weight));
        return this;
    }

    public Schema addSortableTextField(String name, double weight) {
        this.fields.add(new TextField(name, weight, true));
        return this;
    }

    public Schema addGeoField(String name) {
        this.fields.add(new Field(name, FieldType.GEO, false));
        return this;
    }

    public Schema addNumericField(String name) {
        this.fields.add(new Field(name, FieldType.NUMERIC, false));
        return this;
    }

    public Schema addSortableNumericField(String name) {
        this.fields.add(new Field(name, FieldType.NUMERIC, true));
        return this;
    }

    public Schema addTagField(String name) {
        this.fields.add(new TagField(name));
        return this;
    }

    public Schema addTagField(String name, String separator) {
        this.fields.add(new TagField(name, separator));
        return this;
    }

    public Schema addTagField(String name, boolean caseSensitive) {
        this.fields.add(new TagField(name, caseSensitive, false));
        return this;
    }

    public Schema addTagField(String name, String separator, boolean caseSensitive) {
        this.fields.add(new TagField(name, separator, caseSensitive, false));
        return this;
    }

    public Schema addSortableTagField(String name, String separator) {
        this.fields.add(new TagField(name, separator, true));
        return this;
    }

    public Schema addSortableTagField(String name, boolean caseSensitive) {
        this.fields.add(new TagField(name, caseSensitive, true));
        return this;
    }

    public Schema addSortableTagField(String name, String separator, boolean caseSensitive) {
        this.fields.add(new TagField(name, separator, caseSensitive, true));
        return this;
    }

    public Schema addVectorField(String name, VectorField.VectorAlgo algorithm, Map<String, Object> attributes) {
        this.fields.add(new VectorField(name, algorithm, attributes));
        return this;
    }

    public Schema addFlatVectorField(String name, Map<String, Object> attributes) {
        this.fields.add(new VectorField(name, VectorField.VectorAlgo.FLAT, attributes));
        return this;
    }

    public Schema addHNSWVectorField(String name, Map<String, Object> attributes) {
        this.fields.add(new VectorField(name, VectorField.VectorAlgo.HNSW, attributes));
        return this;
    }

    public Schema addField(Field field) {
        this.fields.add(field);
        return this;
    }

    public Schema as(String attribute) {
        this.fields.get(this.fields.size() - 1).as(attribute);
        return this;
    }

    public String toString() {
        return "Schema{fields=" + this.fields + "}";
    }

    public static class VectorField
    extends Field {
        private final VectorAlgo algorithm;
        private final Map<String, Object> attributes;

        public VectorField(String name, VectorAlgo algorithm, Map<String, Object> attributes) {
            super(name, FieldType.VECTOR);
            this.algorithm = algorithm;
            this.attributes = attributes;
        }

        @Override
        public void addTypeArgs(CommandArguments args) {
            args.add((Object)this.algorithm);
            args.add(this.attributes.size() * 2);
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                args.add(entry.getKey());
                args.add(entry.getValue());
            }
        }

        @Override
        public String toString() {
            return "VectorField{name='" + this.fieldName + "', type=" + (Object)((Object)this.type) + ", algorithm=" + (Object)((Object)this.algorithm) + ", attributes=" + this.attributes + "}";
        }

        public static enum VectorAlgo {
            FLAT,
            HNSW;

        }
    }

    public static class TagField
    extends Field {
        private final String separator;
        private final boolean caseSensitive;

        public TagField(String name) {
            this(name, (String)null);
        }

        public TagField(String name, String separator) {
            this(name, separator, false);
        }

        public TagField(String name, boolean sortable) {
            this(name, (String)null, sortable);
        }

        public TagField(String name, String separator, boolean sortable) {
            this(name, separator, false, sortable);
        }

        public TagField(String name, boolean caseSensitive, boolean sortable) {
            this(name, (String)null, caseSensitive, sortable);
        }

        public TagField(String name, String separator, boolean caseSensitive, boolean sortable) {
            super(name, FieldType.TAG, sortable);
            this.separator = separator;
            this.caseSensitive = caseSensitive;
        }

        public TagField(FieldName name, String separator, boolean sortable) {
            this(name, separator, false, sortable);
        }

        public TagField(FieldName name, String separator, boolean caseSensitive, boolean sortable) {
            super(name, FieldType.TAG, sortable, false);
            this.separator = separator;
            this.caseSensitive = caseSensitive;
        }

        @Override
        public void addTypeArgs(CommandArguments args) {
            if (this.separator != null) {
                args.add("SEPARATOR");
                args.add(this.separator);
            }
            if (this.caseSensitive) {
                args.add("CASESENSITIVE");
            }
        }

        @Override
        public String toString() {
            return "TagField{name='" + this.fieldName + "', type=" + (Object)((Object)this.type) + ", sortable=" + this.sortable + ", noindex=" + this.noIndex + ", separator='" + this.separator + ", caseSensitive='" + this.caseSensitive + "'}";
        }
    }

    public static class TextField
    extends Field {
        private final double weight;
        private final boolean nostem;
        private final String phonetic;

        public TextField(String name) {
            this(name, 1.0);
        }

        public TextField(FieldName name) {
            this(name, 1.0, false, false, false, null);
        }

        public TextField(String name, double weight) {
            this(name, weight, false);
        }

        public TextField(String name, double weight, boolean sortable) {
            this(name, weight, sortable, false);
        }

        public TextField(String name, double weight, boolean sortable, boolean nostem) {
            this(name, weight, sortable, nostem, false);
        }

        public TextField(String name, double weight, boolean sortable, boolean nostem, boolean noindex) {
            this(name, weight, sortable, nostem, noindex, null);
        }

        public TextField(String name, double weight, boolean sortable, boolean nostem, boolean noindex, String phonetic) {
            super(name, FieldType.TEXT, sortable, noindex);
            this.weight = weight;
            this.nostem = nostem;
            this.phonetic = phonetic;
        }

        public TextField(FieldName name, double weight, boolean sortable, boolean nostem, boolean noindex, String phonetic) {
            super(name, FieldType.TEXT, sortable, noindex);
            this.weight = weight;
            this.nostem = nostem;
            this.phonetic = phonetic;
        }

        @Override
        protected void addTypeArgs(CommandArguments args) {
            if (this.weight != 1.0) {
                args.add("WEIGHT");
                args.add(Double.toString(this.weight));
            }
            if (this.nostem) {
                args.add("NOSTEM");
            }
            if (this.phonetic != null) {
                args.add("PHONETIC");
                args.add(this.phonetic);
            }
        }

        @Override
        public String toString() {
            return "TextField{name='" + this.fieldName + "', type=" + (Object)((Object)this.type) + ", sortable=" + this.sortable + ", noindex=" + this.noIndex + ", weight=" + this.weight + ", nostem=" + this.nostem + ", phonetic='" + this.phonetic + "'}";
        }
    }

    public static class Field
    implements IParams {
        protected final FieldName fieldName;
        @Deprecated
        public final String name;
        @Deprecated
        public final FieldType type;
        @Deprecated
        public final boolean sortable;
        @Deprecated
        public final boolean noIndex;

        public Field(String name, FieldType type) {
            this(name, type, false, false);
        }

        public Field(String name, FieldType type, boolean sortable) {
            this(name, type, sortable, false);
        }

        public Field(String name, FieldType type, boolean sortable, boolean noindex) {
            this(FieldName.of(name), type, sortable, noindex);
        }

        public Field(FieldName name, FieldType type) {
            this(name, type, false, false);
        }

        public Field(FieldName name, FieldType type, boolean sortable, boolean noIndex) {
            this.fieldName = name;
            this.name = this.fieldName.getName();
            this.type = type;
            this.sortable = sortable;
            this.noIndex = noIndex;
        }

        public void as(String attribute) {
            this.fieldName.as(attribute);
        }

        @Override
        public final void addParams(CommandArguments args) {
            this.fieldName.addParams(args);
            args.add(this.type.name());
            this.addTypeArgs(args);
            if (this.sortable) {
                args.add("SORTABLE");
            }
            if (this.noIndex) {
                args.add("NOINDEX");
            }
        }

        protected void addTypeArgs(CommandArguments args) {
        }

        public String toString() {
            return "Field{name='" + this.fieldName + "', type=" + (Object)((Object)this.type) + ", sortable=" + this.sortable + ", noindex=" + this.noIndex + "}";
        }
    }

    public static enum FieldType {
        TAG,
        TEXT,
        GEO,
        NUMERIC,
        VECTOR;

    }
}

