/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.api.economy;

import fr.maxlego08.essentials.api.economy.PriceFormat;
import java.math.BigDecimal;

public interface Economy {
    public String getName();

    public String getDisplayName();

    public String getSymbol();

    public String getFormat();

    public boolean isVaultEconomy();

    public BigDecimal getMinValue();

    public BigDecimal getMaxValue();

    public BigDecimal getMinPayValue();

    public BigDecimal getMaxPayValue();

    public BigDecimal getMinConfirmInventory();

    public boolean isPaymentEnabled();

    public boolean isConfirmInventoryEnabled();

    public PriceFormat getPriceFormat();

    default public String format(String priceAsString, long amount) {
        return this.getFormat().replace("%price%", priceAsString).replace("%s%", amount > 1L ? "s" : "");
    }
}

