/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.api.worldedit;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.economy.Economy;
import fr.maxlego08.essentials.api.user.Option;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.api.vault.VaultManager;
import fr.maxlego08.essentials.api.worldedit.BlockInfo;
import fr.maxlego08.essentials.api.worldedit.Cuboid;
import fr.maxlego08.essentials.api.worldedit.MaterialPercent;
import fr.maxlego08.essentials.api.worldedit.WorldeditAction;
import fr.maxlego08.essentials.api.worldedit.WorldeditBossBar;
import fr.maxlego08.essentials.api.worldedit.WorldeditManager;
import fr.maxlego08.essentials.api.worldedit.WorldeditRule;
import fr.maxlego08.essentials.api.worldedit.WorldeditStatus;
import fr.maxlego08.essentials.libs.folialib.impl.PlatformScheduler;
import fr.maxlego08.essentials.libs.folialib.wrapper.task.WrappedTask;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public abstract class WorldEditTask {
    protected final EssentialsPlugin plugin;
    protected final WorldeditManager worldeditManager;
    protected final User user;
    protected final Cuboid cuboid;
    protected final List<MaterialPercent> materialPercents;
    protected final Queue<BlockInfo> blockInfos = new LinkedList<BlockInfo>();
    protected final Random random = new Random();
    protected final List<WorldeditRule> worldeditRules = new ArrayList<WorldeditRule>();
    protected int blockAmounts = 0;
    protected WorldeditStatus worldeditStatus = WorldeditStatus.NOTHING;
    protected Map<Material, Long> materials = new HashMap<Material, Long>();
    protected Map<Material, Long> needToGiveMaterials = new HashMap<Material, Long>();
    protected List<Block> blocks = new ArrayList<Block>();
    protected BigDecimal totalPrice;
    protected WrappedTask wrappedTask;

    public WorldEditTask(EssentialsPlugin plugin, WorldeditManager worldeditManager, User user, Cuboid cuboid, List<MaterialPercent> materialPercents) {
        this.plugin = plugin;
        this.worldeditManager = worldeditManager;
        this.user = user;
        this.cuboid = cuboid;
        this.materialPercents = materialPercents;
    }

    public abstract void loadBlocks();

    public abstract WorldeditAction getAction();

    protected void addRules(WorldeditRule ... worldeditRules) {
        this.worldeditRules.addAll(Arrays.asList(worldeditRules));
    }

    public void calculatePrice(Consumer<BigDecimal> consumer) {
        this.worldeditStatus = WorldeditStatus.CALCULATE_PRICE;
        this.plugin.getScheduler().runAsync(wrappedTask -> {
            this.loadBlocks();
            this.processNextBatch(this.blocks.stream().filter(b -> this.worldeditManager.hasPermission(this.user.getPlayer(), (Block)b)).map(b -> new BlockInfo((Block)b, null, BigDecimal.ZERO)).collect(Collectors.toList()), 0, this.worldeditManager.getBatchSize(), () -> {
                this.totalPrice = this.blockInfos.stream().map(BlockInfo::price).reduce(BigDecimal.ZERO, BigDecimal::add);
                this.materials = this.blockInfos.stream().collect(Collectors.groupingBy(BlockInfo::newMaterial, Collectors.counting()));
                this.worldeditStatus = WorldeditStatus.WAITING_RESPONSE_PRICE;
                consumer.accept(this.totalPrice);
            }, blocks -> blocks.forEach(block -> this.processBlock(block.block())));
        });
    }

    protected void processNextBatch(List<BlockInfo> blocks, int startIndex, int batchSize, Runnable runnable, Consumer<List<BlockInfo>> consumer) {
        if (startIndex >= blocks.size()) {
            runnable.run();
            return;
        }
        int endIndex = Math.min(startIndex + batchSize, blocks.size());
        List<BlockInfo> currentBatch = blocks.subList(startIndex, endIndex);
        if (currentBatch.isEmpty()) {
            runnable.run();
            return;
        }
        BlockInfo firstBlock = currentBatch.getFirst();
        PlatformScheduler scheduler = this.plugin.getScheduler();
        scheduler.runAtLocation(firstBlock.block().getLocation(), wrappedTask -> {
            consumer.accept(currentBatch);
            scheduler.runNextTick(wt -> this.processNextBatch(blocks, endIndex, batchSize, runnable, consumer));
        });
    }

    private void processBlock(Block block) {
        Material randomMaterial = this.selectRandomMaterial();
        if (block.getType() == randomMaterial || this.worldeditManager.isBlacklist(block.getType())) {
            return;
        }
        for (WorldeditRule worldeditRule : this.worldeditRules) {
            if (worldeditRule != WorldeditRule.ONLY_AIR || block.getType().isAir()) continue;
            return;
        }
        BigDecimal blockPrice = this.worldeditManager.getMaterialPrice(randomMaterial);
        this.blockInfos.add(new BlockInfo(block, randomMaterial, blockPrice));
    }

    public Material selectRandomMaterial() {
        if (this.materialPercents.size() == 1) {
            return this.materialPercents.getFirst().material();
        }
        double randomValue = this.random.nextDouble() * 100.0;
        double cumulativePercent = 0.0;
        for (MaterialPercent materialPercent : this.materialPercents) {
            if (!(randomValue <= (cumulativePercent += materialPercent.percent()))) continue;
            return materialPercent.material();
        }
        return this.materialPercents.getLast().material();
    }

    public WorldeditStatus getWorldeditStatus() {
        return this.worldeditStatus;
    }

    public void confirm(Consumer<Boolean> consumer) {
        this.worldeditStatus = WorldeditStatus.CHECK_INVENTORY_CONTENT;
        this.plugin.getScheduler().runAsync(wrappedTask -> {
            boolean result;
            Player player = this.user.getPlayer();
            if (this.getAction() == WorldeditAction.PLACE) {
                result = this.hasRequiredItems(player, this.materials);
                if (!result) {
                    this.worldeditStatus = WorldeditStatus.NOT_ENOUGH_ITEMS;
                }
            } else {
                result = true;
            }
            this.plugin.getScheduler().runNextTick(wrappedTask1 -> consumer.accept(result));
        });
    }

    public void startPlaceBlocks() {
        this.worldeditStatus = WorldeditStatus.RUNNING;
        Player player = this.user.getPlayer();
        this.removeRequiredItems(player, this.materials);
        this.blockAmounts = this.blockInfos.size();
        this.process();
        if (!this.user.getOption(Option.WORLDEDIT_BOSSBAR_DISABLE)) {
            WorldeditBossBar bossBar = this.worldeditManager.getWorldeditBar();
            int speed = this.worldeditManager.getBlocksPerSecond(this.user.getPlayer());
            double seconds = (double)this.count() / (double)speed;
            bossBar.create(player, this.worldeditManager.getWorldeditConfiguration(), (long)(seconds * 1000.0));
        }
    }

    private void updateBossBar() {
        if (!this.user.getOption(Option.WORLDEDIT_BOSSBAR_DISABLE)) {
            WorldeditBossBar bossBar = this.worldeditManager.getWorldeditBar();
            int currentSize = this.count();
            int speed = this.worldeditManager.getBlocksPerSecond(this.user.getPlayer());
            double seconds = (double)this.count() / (double)speed;
            bossBar.update(this.user.getPlayer(), (float)currentSize / (float)this.blockAmounts, (long)(seconds * 1000.0));
        }
    }

    public BigDecimal getTotalPrice() {
        return this.totalPrice;
    }

    private boolean hasRequiredItems(Player player, Map<Material, Long> requiredItems) {
        PlayerInventory inventory = player.getInventory();
        VaultManager vaultManager = this.plugin.getVaultManager();
        for (Map.Entry<Material, Long> entry : requiredItems.entrySet()) {
            long amountInVault;
            Material material = entry.getKey();
            long requiredAmount = entry.getValue();
            long totalAmount = 0L;
            if (this.useInventory()) {
                for (ItemStack item : inventory.getContents()) {
                    if (item == null || item.getType() != material) continue;
                    totalAmount += (long)item.getAmount();
                }
            }
            if (totalAmount >= requiredAmount || (totalAmount += (amountInVault = vaultManager.getMaterialAmount(player, material))) >= requiredAmount) continue;
            return false;
        }
        return true;
    }

    public void removeRequiredItems(Player player, Map<Material, Long> requiredItems) {
        PlayerInventory inventory = player.getInventory();
        VaultManager vaultManager = this.plugin.getVaultManager();
        for (Map.Entry<Material, Long> entry : requiredItems.entrySet()) {
            Material material = entry.getKey();
            long amountToRemove = entry.getValue();
            if (this.useInventory()) {
                for (int i = 0; i < inventory.getSize(); ++i) {
                    ItemStack item = inventory.getItem(i);
                    if (item == null || item.getType() != material) continue;
                    long itemAmount = item.getAmount();
                    if (itemAmount > amountToRemove) {
                        item.setAmount((int)(itemAmount - amountToRemove));
                        amountToRemove = 0L;
                        break;
                    }
                    inventory.clear(i);
                    if ((amountToRemove -= itemAmount) == 0L) break;
                }
            }
            if (amountToRemove <= 0L) continue;
            vaultManager.removeMaterial(player, material, amountToRemove);
        }
    }

    protected void finish() {
        this.worldeditStatus = WorldeditStatus.FINISH;
        this.user.setWorldeditTask(null);
        this.worldeditManager.sendFinishMessage(this.user);
        this.giveItems(this.user.getPlayer(), this.needToGiveMaterials);
        if (!this.user.getOption(Option.WORLDEDIT_BOSSBAR_DISABLE)) {
            this.worldeditManager.getWorldeditBar().remove(this.user.getPlayer());
        }
    }

    public Map<Material, Long> getMaterials() {
        return this.materials;
    }

    protected void add(Material material) {
        this.needToGiveMaterials.put(material, this.needToGiveMaterials.getOrDefault(material, 0L) + 1L);
    }

    public void giveItems(Player player, Map<Material, Long> itemsToGive) {
        VaultManager vaultManager = this.plugin.getVaultManager();
        if (this.useInventory()) {
            PlayerInventory inventory = player.getInventory();
            for (Map.Entry<Material, Long> entry : itemsToGive.entrySet()) {
                int stackSize;
                Material material2 = entry.getKey();
                for (long amount2 = entry.getValue().longValue(); amount2 > 0L; amount2 -= (long)stackSize) {
                    stackSize = (int)Math.min(amount2, (long)material2.getMaxStackSize());
                    ItemStack itemStack = new ItemStack(material2, stackSize);
                    HashMap remainingItems = inventory.addItem(new ItemStack[]{itemStack});
                    if (remainingItems.isEmpty()) continue;
                    for (ItemStack remainingItem : remainingItems.values()) {
                        vaultManager.addItem(player.getUniqueId(), remainingItem);
                    }
                }
            }
        } else {
            itemsToGive.forEach((material, amount) -> vaultManager.addItem(player.getUniqueId(), new ItemStack(material), (long)amount));
        }
    }

    public void process() {
        int blocksPerTick;
        int intervalTicks;
        PlatformScheduler scheduler = this.plugin.getScheduler();
        int blocksPerSecond = this.worldeditManager.getBlocksPerSecond(this.user.getPlayer());
        if (blocksPerSecond <= 20) {
            intervalTicks = 20 / blocksPerSecond;
            blocksPerTick = 1;
        } else {
            intervalTicks = 1;
            blocksPerTick = blocksPerSecond / 20;
        }
        AtomicInteger tickCounter = new AtomicInteger();
        int additionalBlocks = blocksPerSecond % 20;
        this.wrappedTask = scheduler.runTimerAsync(() -> {
            if (this.blockInfos.isEmpty()) {
                this.wrappedTask.cancel();
                this.finish();
                return;
            }
            for (int i = 0; i < blocksPerTick; ++i) {
                if (this.blockInfos.isEmpty()) continue;
                this.placeBlock(this.blockInfos.poll());
            }
            if (blocksPerSecond > 20 && tickCounter.get() < additionalBlocks && !this.blockInfos.isEmpty()) {
                this.placeBlock(this.blockInfos.poll());
            }
            tickCounter.getAndIncrement();
            this.updateBossBar();
        }, 0L, (long)intervalTicks);
    }

    private void placeBlock(BlockInfo blockInfo) {
        if (blockInfo == null) {
            return;
        }
        PlatformScheduler scheduler = this.plugin.getScheduler();
        Block block = blockInfo.block();
        scheduler.runAtLocation(block.getLocation(), wrappedTask -> {
            Material currentType = block.getType();
            if (this.worldeditManager.isBlacklist(currentType)) {
                return;
            }
            if (!currentType.isAir()) {
                this.add(currentType);
            }
            block.setType(blockInfo.newMaterial());
            if (!blockInfo.newMaterial().isAir()) {
                this.plugin.getBlockTracker().track(block);
            }
        });
    }

    public int count() {
        return this.blockInfos.size();
    }

    public void cancel(Player player) {
        if (this.worldeditStatus != WorldeditStatus.RUNNING) {
            return;
        }
        this.worldeditStatus = WorldeditStatus.CANCELLED;
        this.wrappedTask.cancel();
        BigDecimal refundPrice = this.blockInfos.stream().map(BlockInfo::price).reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<Material, Long> refundMaterials = this.getAction() == WorldeditAction.PLACE ? this.blockInfos.stream().collect(Collectors.groupingBy(BlockInfo::newMaterial, Collectors.counting())) : new HashMap<Material, Long>();
        this.blockInfos.clear();
        Economy economy = this.plugin.getEconomyManager().getDefaultEconomy();
        this.user.deposit(economy, refundPrice, this.worldeditManager.getRefundMessage());
        refundMaterials.putAll(this.needToGiveMaterials);
        this.giveItems(player, refundMaterials);
        this.worldeditManager.sendRefundMessage(player, refundMaterials, refundPrice, economy);
        this.user.setWorldeditTask(null);
        if (!this.user.getOption(Option.WORLDEDIT_BOSSBAR_DISABLE)) {
            this.worldeditManager.getWorldeditBar().remove(player);
        }
    }

    protected double lengthSq(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    protected double lengthSq(double x, double z) {
        return x * x + z * z;
    }

    private boolean useInventory() {
        return this.user.getOption(Option.WORLDEDIT_INVENTORY);
    }
}

