/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.cooldown;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.dto.CooldownDTO;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.storage.IStorage;
import fr.maxlego08.essentials.zutils.utils.TimerBuilder;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.UUID;
import org.bukkit.command.CommandSender;

public class CommandCooldownShow
extends VCommand {
    public CommandCooldownShow(EssentialsPlugin plugin) {
        super(plugin);
        this.addSubCommand("show", "s");
        this.setPermission(Permission.ESSENTIALS_COOLDOWN_SHOW);
        this.setDescription(Message.DESCRIPTION_COOLDOWN_SHOW);
        this.addOptionalOfflinePlayerNameArg();
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        CommandSender sender = this.sender;
        String userName = this.argAsString(0);
        this.fetchUniqueId(userName, uniqueId -> {
            IStorage iStorage = plugin.getStorageManager().getStorage();
            List<CooldownDTO> cooldownDTOS = iStorage.getCooldowns((UUID)uniqueId).stream().filter(dto -> dto.cooldown_value() > System.currentTimeMillis()).toList();
            if (cooldownDTOS.isEmpty()) {
                this.message(sender, Message.COMMAND_COOLDOWN_EMPTY, "%player%", userName);
                return;
            }
            SimpleDateFormat simpleDateFormat = plugin.getConfiguration().getGlobalDateFormat();
            this.message(sender, Message.COMMAND_COOLDOWN_HEADER, "%player%", userName, "%amount%", cooldownDTOS.size());
            cooldownDTOS.forEach(cooldownDTO -> {
                long ms = cooldownDTO.cooldown_value() - System.currentTimeMillis();
                this.message(sender, Message.COMMAND_COOLDOWN_LINE, "%key%", cooldownDTO.cooldown_name(), "%value%", cooldownDTO.cooldown_value(), "%createdAt%", simpleDateFormat.format(cooldownDTO.created_at()), "%timeLeft%", TimerBuilder.getStringTime(ms), "%player%", userName);
            });
        });
        return CommandResultType.SUCCESS;
    }
}

