/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.economy;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.economy.Economy;
import fr.maxlego08.essentials.api.economy.EconomyManager;
import fr.maxlego08.essentials.api.economy.NumberMultiplicationFormat;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.user.Option;
import fr.maxlego08.essentials.module.modules.economy.EconomyModule;
import fr.maxlego08.essentials.user.ZUser;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.bukkit.plugin.Plugin;

public class CommandPay
extends VCommand {
    public CommandPay(EssentialsPlugin plugin) {
        super(plugin);
        this.setModule(EconomyModule.class);
        this.setPermission(Permission.ESSENTIALS_PAY);
        this.setDescription(Message.DESCRIPTION_PAY);
        this.onlyPlayers();
        this.addRequirePlayerNameArg();
        this.addRequireArg("amount", (a, b) -> Stream.of(10, 20, 30, 40, 50, 60, 70, 80, 90).map(String::valueOf).toList());
        this.addOptionalArg("economy", (a, b) -> plugin.getEconomyManager().getEconomies().stream().map(Economy::getName).toList());
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        Optional<Economy> optionalEconomy;
        EconomyManager economyManager = plugin.getEconomyManager();
        String userName = this.argAsString(0);
        String amountAsString = this.argAsString(1);
        String economyName = this.argAsString(2, economyManager.getDefaultEconomy().getName());
        if (amountAsString.contains("-")) {
            this.message(this.sender, Message.COMMAND_PAY_NEGATIVE, new Object[0]);
            return CommandResultType.DEFAULT;
        }
        String sanitizedString = amountAsString.replaceAll("[^0-9.]", "");
        if (sanitizedString.isEmpty()) {
            return CommandResultType.SYNTAX_ERROR;
        }
        BigDecimal amount = new BigDecimal(amountAsString.replaceAll("[^0-9.]", ""));
        String format = amountAsString.replace(sanitizedString, "");
        Optional<NumberMultiplicationFormat> optional = economyManager.getMultiplication(format);
        if (optional.isPresent()) {
            NumberMultiplicationFormat numberMultiplicationFormat = optional.get();
            amount = amount.multiply(numberMultiplicationFormat.multiplication());
        }
        if ((optionalEconomy = economyManager.getEconomy(economyName)).isEmpty()) {
            this.message(this.sender, Message.COMMAND_ECONOMY_NOT_FOUND, "%name%", economyName);
            return CommandResultType.DEFAULT;
        }
        Economy economy = optionalEconomy.get();
        if (!economy.isPaymentEnabled()) {
            this.message(this.sender, Message.COMMAND_PAY_DISABLE, "%name%", economy.getDisplayName());
            return CommandResultType.DEFAULT;
        }
        if (amount.compareTo(economy.getMinPayValue()) < 0) {
            this.message(this.sender, Message.COMMAND_PAY_MIN, "%amount%", economyManager.format(economy, (Number)economy.getMinPayValue()));
            return CommandResultType.DEFAULT;
        }
        if (amount.compareTo(economy.getMaxPayValue()) > 0) {
            this.message(this.sender, Message.COMMAND_PAY_MAX, "%amount%", economyManager.format(economy, (Number)economy.getMaxPayValue()));
            return CommandResultType.DEFAULT;
        }
        if (userName.equalsIgnoreCase(this.player.getName())) {
            this.message(this.sender, Message.COMMAND_PAY_SELF, new Object[0]);
            return CommandResultType.DEFAULT;
        }
        if (this.user.getBalance(economy).compareTo(amount) < 0) {
            this.message(this.sender, Message.COMMAND_PAY_NOT_ENOUGH, new Object[0]);
            return CommandResultType.DEFAULT;
        }
        BigDecimal finalAmount = amount;
        this.fetchUniqueId(userName, uniqueId -> this.checkOption((UUID)uniqueId, Option.PAY_DISABLE, isDisable -> {
            if (isDisable.booleanValue()) {
                this.message(this.sender, Message.COMMAND_PAY_DISABLED, new Object[0]);
                return;
            }
            if (economy.isConfirmInventoryEnabled() && finalAmount.compareTo(economy.getMinConfirmInventory()) > 0) {
                ZUser fakeUser = new ZUser(plugin, (UUID)uniqueId);
                fakeUser.setName(userName);
                this.user.setTargetPay(fakeUser, economy, finalAmount);
                plugin.getScheduler().runAtLocation(this.player.getLocation(), wrappedTask -> plugin.getInventoryManager().openInventory(this.player, (Plugin)plugin, "confirm_pay_inventory"));
                return;
            }
            economyManager.pay(this.player.getUniqueId(), this.player.getName(), (UUID)uniqueId, userName, economy, finalAmount);
        }));
        return CommandResultType.SUCCESS;
    }
}

