/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.utils;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.utils.TransformMaterial;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class CommandCompact
extends VCommand {
    public CommandCompact(EssentialsPlugin plugin) {
        super(plugin);
        this.setPermission(Permission.ESSENTIALS_COMPACT);
        this.setDescription(Message.DESCRIPTION_COMPACT);
        this.addRequireArg("type", (a, b) -> plugin.getConfiguration().getCompactMaterials().stream().map(e -> e.from().name().toLowerCase()).toList());
        this.onlyPlayers();
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        Material material = Material.valueOf((String)this.argAsString(0).toUpperCase());
        Optional<TransformMaterial> optional = this.configuration.getCompactMaterials().stream().filter(e -> e.from().equals((Object)material)).findFirst();
        if (optional.isEmpty()) {
            this.message(this.sender, Message.COMMAND_COMPACT_TYPE, "%material%", this.name(material.name()));
            return CommandResultType.DEFAULT;
        }
        TransformMaterial compactMaterial = optional.get();
        Material newMaterial = compactMaterial.to();
        PlayerInventory inventory = this.player.getInventory();
        int amountOf = this.count((Inventory)inventory, material);
        if (amountOf < 9) {
            this.message((CommandSender)this.getPlayer(), Message.COMMAND_COMPACT_ERROR, "%item%", this.name(material.name()));
            return CommandResultType.DEFAULT;
        }
        int realAmount = amountOf / 9;
        this.removeItems((Inventory)inventory, new ItemStack(material), realAmount * 9);
        this.plugin.give(this.player, new ItemStack(newMaterial, realAmount));
        this.message((CommandSender)this.player, Message.COMMAND_COMPACT_SUCCESS, "%amount%", realAmount * 9, "%item%", this.name(material.name()), "%toAmount%", realAmount, "%toItem%", this.name(newMaterial.name()));
        return CommandResultType.SUCCESS;
    }
}

