/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands.commands.utils.admins;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.user.Option;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.zutils.utils.commands.VCommand;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class CommandVanish
extends VCommand {
    public CommandVanish(EssentialsPlugin plugin) {
        super(plugin);
        this.setPermission(Permission.ESSENTIALS_VANISH);
        this.setDescription(Message.DESCRIPTION_VANISH);
        this.addOptionalArg("player", this.getOnlinePlayers());
    }

    @Override
    protected CommandResultType perform(EssentialsPlugin plugin) {
        Message messageKey;
        User user;
        Player player = this.argAsPlayer(0, this.player);
        if (player == null) {
            return CommandResultType.SYNTAX_ERROR;
        }
        boolean self = player.equals((Object)this.player);
        if (!self && !this.hasPermission((Permissible)this.sender, Permission.ESSENTIALS_VANISH_OTHER)) {
            this.message(this.sender, Message.COMMAND_NO_PERMISSION, new Object[0]);
            return CommandResultType.NO_PERMISSION;
        }
        User user2 = user = self ? this.user : this.getUser(player);
        if (user == null) {
            this.message(this.sender, Message.PLAYER_NOT_FOUND, "%player%", player.getName());
            return CommandResultType.DEFAULT;
        }
        boolean vanish = !user.getOption(Option.VANISH);
        user.setOption(Option.VANISH, vanish);
        this.updateVanishState(plugin, player, vanish);
        Message message = messageKey = vanish ? Message.COMMAND_VANISH_ENABLE : Message.COMMAND_VANISH_DISABLE;
        if (self) {
            this.message(this.sender, messageKey, "%player%", Message.YOU.getMessageAsString());
        } else {
            this.message(this.sender, messageKey, "%player%", player.getName());
            this.message((CommandSender)player, messageKey, "%player%", Message.YOU.getMessageAsString());
        }
        return CommandResultType.SUCCESS;
    }
}

