/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.hooks;

import com.artillexstudios.axvaults.AxVaults;
import com.artillexstudios.axvaults.database.Database;
import com.artillexstudios.axvaults.libs.axapi.serializers.Serializers;
import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.vault.VaultManager;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;

public class AxVaultsHook {
    public AxVaultsHook(EssentialsPlugin plugin) {
        this.loadVaults(plugin);
    }

    public void loadVaults(EssentialsPlugin plugin) {
        try {
            VaultManager manager = plugin.getVaultManager();
            Database database = AxVaults.getDatabase();
            Field field = database.getClass().getDeclaredField("conn");
            field.setAccessible(true);
            Object conn = field.get(database);
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodType typePrepareStatement = MethodType.methodType(PreparedStatement.class, String.class);
            MethodHandle prepareStatement = lookup.findVirtual(conn.getClass(), "prepareStatement", typePrepareStatement);
            try (PreparedStatement statement = prepareStatement.invoke(conn, "SELECT * FROM axvaults_data ORDER BY uuid ASC");
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    ItemStack[] itemStacks;
                    UUID uuid = UUID.fromString(resultSet.getString("uuid"));
                    byte[] bytes = resultSet.getBytes("storage");
                    for (ItemStack itemStack : itemStacks = (ItemStack[])Serializers.ITEM_ARRAY.deserialize((Object)bytes)) {
                        if (itemStack == null || itemStack.getType().isAir()) continue;
                        manager.addItem(uuid, itemStack);
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

