/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.hooks;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.economy.EconomyManager;
import fr.maxlego08.essentials.api.user.User;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;

public class VaultEconomy
implements Economy {
    private final EssentialsPlugin essentialsPlugin;

    public VaultEconomy(EssentialsPlugin essentialsPlugin) {
        this.essentialsPlugin = essentialsPlugin;
        essentialsPlugin.getServer().getServicesManager().register(Economy.class, (Object)this, (Plugin)essentialsPlugin, ServicePriority.Highest);
    }

    private fr.maxlego08.essentials.api.economy.Economy getEconomy() {
        return this.essentialsPlugin.getEconomyManager().getVaultEconomy();
    }

    public boolean isEnabled() {
        return this.essentialsPlugin.isEconomyEnable();
    }

    public String getName() {
        return "zEssentials Economy";
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return -1;
    }

    public String format(double amount) {
        return this.essentialsPlugin.getEconomyManager().format(this.getEconomy(), (Number)amount);
    }

    public String currencyNamePlural() {
        return this.currencyNameSingular();
    }

    public String currencyNameSingular() {
        return this.getEconomy().getSymbol();
    }

    public boolean hasAccount(String playerName) {
        return true;
    }

    public boolean hasAccount(OfflinePlayer player) {
        return true;
    }

    public boolean hasAccount(String playerName, String worldName) {
        return true;
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        return true;
    }

    public double getBalance(String playerName) {
        return this.getBalance(Bukkit.getOfflinePlayer((String)playerName));
    }

    public double getBalance(OfflinePlayer player) {
        User user;
        if (player.isOnline() && (user = this.essentialsPlugin.getStorageManager().getStorage().getUser(player.getUniqueId())) != null) {
            return user.getBalance(this.getEconomy()).doubleValue();
        }
        return this.getBalanceOfflinePlayer(player);
    }

    private double getBalanceOfflinePlayer(OfflinePlayer offlinePlayer) {
        return this.essentialsPlugin.getEconomyManager().getBalanceOffline(offlinePlayer.getUniqueId()).doubleValue();
    }

    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.getBalance(player);
    }

    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    public boolean has(OfflinePlayer player, double amount) {
        return this.getBalance(player) >= amount;
    }

    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    public boolean has(OfflinePlayer player, String worldName, double amount) {
        return this.has(player, amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        return this.withdrawPlayer(Bukkit.getOfflinePlayer((String)playerName), amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        fr.maxlego08.essentials.api.economy.Economy economy = this.getEconomy();
        double newAmount = this.getBalance(player) - amount;
        if (new BigDecimal(newAmount).compareTo(economy.getMinValue()) < 0) {
            return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.FAILURE, "Not enough money");
        }
        EconomyManager economyManager = this.essentialsPlugin.getEconomyManager();
        economyManager.withdraw(player.getUniqueId(), this.getEconomy(), new BigDecimal(amount));
        return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.SUCCESS, "Yeah its work");
    }

    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        return this.depositPlayer(Bukkit.getOfflinePlayer((String)playerName), amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        EconomyManager economyManager = this.essentialsPlugin.getEconomyManager();
        economyManager.deposit(player.getUniqueId(), this.getEconomy(), new BigDecimal(amount));
        return new EconomyResponse(amount, 0.0, EconomyResponse.ResponseType.SUCCESS, "Yeah its work");
    }

    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.depositPlayer(player, amount);
    }

    public EconomyResponse createBank(String name, String player) {
        return null;
    }

    public EconomyResponse createBank(String name, OfflinePlayer player) {
        return null;
    }

    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "no bank");
    }

    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "no bank");
    }

    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "no bank");
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "no bank");
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "no bank");
    }

    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "no bank");
    }

    public EconomyResponse isBankOwner(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "no bank");
    }

    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "no bank");
    }

    public EconomyResponse isBankMember(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "no bank");
    }

    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    public boolean createPlayerAccount(String playerName) {
        return false;
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        return false;
    }

    public boolean createPlayerAccount(String playerName, String worldName) {
        return false;
    }

    public boolean createPlayerAccount(OfflinePlayer player, String worldName) {
        return false;
    }
}

