/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.hooks.protocollib;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.messages.MessageUtils;
import fr.maxlego08.essentials.api.packet.PacketRegister;
import fr.maxlego08.essentials.api.utils.component.AdventureComponent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.plugin.Plugin;

public class PacketChatListener
extends PacketAdapter
implements PacketRegister {
    private final EssentialsPlugin plugin;
    private final String result;
    private final Pattern pattern = Pattern.compile("\\./(.*?)(?=\\.|</|$)");

    public PacketChatListener(EssentialsPlugin plugin, String result) {
        super(PacketAdapter.params().plugin((Plugin)plugin).listenerPriority(ListenerPriority.HIGHEST).types(new PacketType[]{PacketType.Play.Server.SYSTEM_CHAT}));
        this.plugin = plugin;
        this.result = result;
    }

    public void onPacketSending(PacketEvent event) {
        Boolean asBoolean;
        PacketContainer packet = event.getPacket();
        Object isActionBar = packet.getModifier().read(1);
        if (isActionBar instanceof Boolean && (asBoolean = (Boolean)isActionBar).booleanValue()) {
            return;
        }
        WrappedChatComponent wrappedChatComponent = (WrappedChatComponent)packet.getChatComponents().readSafely(0);
        if (wrappedChatComponent == null) {
            return;
        }
        String json = wrappedChatComponent.getJson();
        String serializedMessage = "ToDo";
        Matcher matcher = this.pattern.matcher(serializedMessage);
        if (matcher.find()) {
            Component newComponent = this.fixClickEvent(this.parseComponent(serializedMessage));
            packet.getChatComponents().write(0, (Object)WrappedChatComponent.fromJson((String)((String)GsonComponentSerializer.gson().serialize(newComponent))));
        }
    }

    @Override
    public void addPacketListener() {
        if (this.result == null) {
            this.plugin.getLogger().severe("Cannot use ProtocolLib, your configuration command-placeholder.result is invalid !");
            return;
        }
        this.plugin.getLogger().info("Start listening packet System Chat");
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this);
    }

    private Component parseComponent(String message) {
        AdventureComponent adventureComponent = (AdventureComponent)this.plugin.getComponentMessage();
        TagResolver.Builder builder = TagResolver.builder();
        Matcher matcher = this.pattern.matcher(message);
        StringBuilder formattedMessage = new StringBuilder();
        while (matcher.find()) {
            String command = matcher.group(1);
            String placeholderTag = MessageUtils.removeNonAlphanumeric("cmd_" + command.replace(" ", "_"));
            builder.resolver((TagResolver)Placeholder.component((String)placeholderTag, (ComponentLike)adventureComponent.getComponent(this.result.replace("%command%", command).replace("%fixed_command%", command.replace("'", "\\'")))));
            matcher.appendReplacement(formattedMessage, "<" + placeholderTag + ">");
        }
        matcher.appendTail(formattedMessage);
        return adventureComponent.getComponent(formattedMessage.toString(), builder.build());
    }

    private Component fixClickEvent(Component component) {
        ClickEvent event = component.clickEvent();
        Component copied = component;
        if (event != null && event.value().startsWith("&f")) {
            copied = component.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)event.action(), (String)event.value().substring(2)));
        }
        copied = copied.children(copied.children().stream().map(this::fixClickEvent).collect(Collectors.toList()));
        return copied;
    }
}

