/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.hooks.redis;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.cache.ExpiringCache;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.server.EssentialsServer;
import fr.maxlego08.essentials.api.server.RedisConfiguration;
import fr.maxlego08.essentials.api.server.ServerMessageType;
import fr.maxlego08.essentials.api.server.messages.ChatClear;
import fr.maxlego08.essentials.api.server.messages.ChatToggle;
import fr.maxlego08.essentials.api.server.messages.ClearCooldown;
import fr.maxlego08.essentials.api.server.messages.KickMessage;
import fr.maxlego08.essentials.api.server.messages.ServerMessage;
import fr.maxlego08.essentials.api.server.messages.ServerPrivateMessage;
import fr.maxlego08.essentials.api.server.messages.UpdateCooldown;
import fr.maxlego08.essentials.api.storage.IStorage;
import fr.maxlego08.essentials.api.user.Option;
import fr.maxlego08.essentials.api.user.PrivateMessage;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.api.utils.EssentialsUtils;
import fr.maxlego08.essentials.api.utils.PlayerCache;
import fr.maxlego08.essentials.hooks.redis.RedisMessage;
import fr.maxlego08.essentials.hooks.redis.RedisSubscriberRunnable;
import fr.maxlego08.essentials.hooks.redis.listener.ChatClearListener;
import fr.maxlego08.essentials.hooks.redis.listener.ChatToggleListener;
import fr.maxlego08.essentials.hooks.redis.listener.ClearCooldownListener;
import fr.maxlego08.essentials.hooks.redis.listener.KickListener;
import fr.maxlego08.essentials.hooks.redis.listener.MessageListener;
import fr.maxlego08.essentials.hooks.redis.listener.PrivateMessageListener;
import fr.maxlego08.essentials.hooks.redis.listener.UpdateCooldownListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisServer
implements EssentialsServer,
Listener {
    private final RedisSubscriberRunnable redisSubscriberRunnable;
    private final PlayerCache playerCache = new PlayerCache();
    private final UUID instanceId = UUID.randomUUID();
    private final EssentialsPlugin plugin;
    private final EssentialsUtils utils;
    private final String playersKey = "essentials:playerlist";
    private final ExpiringCache<String, Boolean> onlineCache = new ExpiringCache(30000L);
    private JedisPool jedisPool;

    public RedisServer(EssentialsPlugin plugin) {
        this.plugin = plugin;
        this.utils = plugin.getUtils();
        this.redisSubscriberRunnable = new RedisSubscriberRunnable(plugin, this);
    }

    @Override
    public void onEnable() {
        RedisConfiguration redisConfiguration = this.plugin.getConfiguration().getRedisConfiguration();
        String password = redisConfiguration.password();
        if (password == null) {
            this.jedisPool = new JedisPool(redisConfiguration.host(), redisConfiguration.port());
        } else {
            JedisPoolConfig poolConfigBuilder = new JedisPoolConfig();
            this.jedisPool = new JedisPool((GenericObjectPoolConfig<Jedis>)poolConfigBuilder, redisConfiguration.host(), redisConfiguration.port(), 2000, password);
        }
        this.plugin.getLogger().info("Redis connected to " + redisConfiguration.host() + ":" + redisConfiguration.port());
        this.registerListener();
        Thread thread = new Thread(this.redisSubscriberRunnable);
        thread.start();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.plugin.getScheduler().runTimerAsync(() -> this.playerCache.setPlayers(this.jedisPool.getResource().smembers(this.playersKey)), 1L, 1L, TimeUnit.MINUTES);
    }

    private void registerListener() {
        this.redisSubscriberRunnable.registerListener(KickMessage.class, new KickListener(this.utils));
        this.redisSubscriberRunnable.registerListener(ServerMessage.class, new MessageListener(this.utils));
        this.redisSubscriberRunnable.registerListener(ChatClear.class, new ChatClearListener(this));
        this.redisSubscriberRunnable.registerListener(ChatToggle.class, new ChatToggleListener(this.utils));
        this.redisSubscriberRunnable.registerListener(ServerPrivateMessage.class, new PrivateMessageListener(this.plugin));
        this.redisSubscriberRunnable.registerListener(ClearCooldown.class, new ClearCooldownListener(this.utils));
        this.redisSubscriberRunnable.registerListener(UpdateCooldown.class, new UpdateCooldownListener(this.utils));
    }

    @Override
    public void onDisable() {
        if (this.jedisPool != null) {
            this.execute(jedis -> jedis.srem(this.playersKey, Bukkit.getOnlinePlayers().stream().map(Player::getName).toList().toArray(new String[0])), false);
            this.jedisPool.close();
        }
    }

    @Override
    public List<String> getPlayersNames() {
        return new ArrayList<String>(this.playerCache.getPlayers());
    }

    @Override
    public List<String> getOfflinePlayersNames() {
        return this.plugin.getConfiguration().isEnableOfflinePlayersName() ? Arrays.stream(Bukkit.getOfflinePlayers()).map(OfflinePlayer::getName).toList() : this.getPlayersNames();
    }

    @Override
    public void sendMessage(UUID uuid, Message message, Object ... objects) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            this.utils.message(uuid, message, objects);
            return;
        }
        this.sendMessage(ServerMessage.single(uuid, message, objects));
    }

    @Override
    public void broadcastMessage(Permission permission, Message message, Object ... objects) {
        this.utils.broadcast(permission, message, objects);
        this.sendMessage(new ServerMessage(ServerMessageType.BROADCAST_PERMISSION, null, permission, null, message, objects));
    }

    @Override
    public void broadcastMessage(Option option, Message message, Object ... objects) {
        this.utils.broadcast(option, message, objects);
        this.sendMessage(new ServerMessage(ServerMessageType.BROADCAST_OPTION, null, null, option, message, objects));
    }

    @Override
    public void broadcast(String message) {
        this.utils.broadcast(Message.COMMAND_CHAT_BROADCAST, "%message%", message);
        this.sendMessage(new ServerMessage(ServerMessageType.BROADCAST, null, null, null, Message.COMMAND_CHAT_BROADCAST, new String[]{"%message%", message}));
    }

    @Override
    public void pub(Player player, String message) {
        this.utils.broadcast(Message.COMMAND_PUB, "%message%", message, "%player%", player.getName());
        this.sendMessage(new ServerMessage(ServerMessageType.BROADCAST, null, null, null, Message.COMMAND_PUB, new String[]{"%message%", message, "%player%", player.getName()}));
    }

    @Override
    public void sendPrivateMessage(User user, PrivateMessage privateMessage, String message) {
        IStorage iStorage = this.plugin.getStorageManager().getStorage();
        User targetUser = iStorage.getUser(privateMessage.uuid());
        if (targetUser == null) {
            ServerPrivateMessage serverPrivateMessage = new ServerPrivateMessage(user.getUniqueId(), user.getName(), privateMessage.uuid(), message);
            this.sendMessage(serverPrivateMessage);
            return;
        }
        PrivateMessage privateMessageReply = targetUser.setPrivateMessage(user.getUniqueId(), user.getName());
        this.plugin.getUtils().sendPrivateMessage(targetUser, privateMessageReply, Message.COMMAND_MESSAGE_OTHER, message);
    }

    @Override
    public void kickPlayer(UUID uuid, Message message, Object ... objects) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null && player.isOnline()) {
            this.utils.kick(player, message, objects);
            return;
        }
        this.sendMessage(new KickMessage(uuid, message, objects));
    }

    @Override
    public boolean isOnline(String userName) {
        return this.onlineCache.get(userName, () -> this.jedisPool.getResource().sismember("essentials:playerlist", userName));
    }

    @Override
    public void clearChat(CommandSender sender) {
        this.clearLocalChat();
        this.sendMessage(new ChatClear());
    }

    @Override
    public void toggleChat(boolean value) {
        this.utils.toggleChat(value);
        this.sendMessage(new ChatToggle(value));
    }

    @Override
    public void deleteCooldown(UUID uniqueId, String cooldownName) {
        this.utils.deleteCooldown(uniqueId, cooldownName);
        this.sendMessage(new ClearCooldown(uniqueId, cooldownName));
    }

    @Override
    public void updateCooldown(UUID uniqueId, String cooldownName, long expiredAt) {
        this.utils.updateCooldown(uniqueId, cooldownName, expiredAt);
        this.sendMessage(new UpdateCooldown(uniqueId, cooldownName, expiredAt));
    }

    public void clearLocalChat() {
        Bukkit.getOnlinePlayers().forEach(player -> {
            for (int i = 0; i != 300; ++i) {
                player.sendMessage((Component)Component.text((String)""));
            }
            this.utils.message((CommandSender)player, Message.COMMAND_CHAT_CLEAR, new Object[0]);
        });
        this.utils.message((CommandSender)Bukkit.getConsoleSender(), Message.COMMAND_CHAT_CLEAR, new Object[0]);
    }

    private <T> void sendMessage(T message) {
        this.plugin.getScheduler().runAsync(wrappedTask -> {
            String jsonMessage = this.plugin.getGson().toJson(new RedisMessage<Object>(this.instanceId, message, message.getClass().getName()));
            this.plugin.debug("Send: " + jsonMessage);
            this.jedisPool.getResource().publish("essentials:messages", jsonMessage);
        });
    }

    public EssentialsPlugin getPlugin() {
        return this.plugin;
    }

    public EssentialsUtils getUtils() {
        return this.utils;
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public UUID getInstanceId() {
        return this.instanceId;
    }

    public PlayerCache getPlayerCache() {
        return this.playerCache;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        String playerName = event.getPlayer().getName();
        this.playerCache.addPlayer(playerName);
        this.execute(jedis -> jedis.sadd(this.playersKey, playerName));
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        String playerName = event.getPlayer().getName();
        this.playerCache.removePlayer(playerName);
        this.execute(jedis -> jedis.srem(this.playersKey, playerName));
    }

    private void execute(Consumer<Jedis> consumer) {
        this.execute(consumer, true);
    }

    private void execute(Consumer<Jedis> consumer, boolean async) {
        Runnable runnable = () -> {
            try {
                if (!this.jedisPool.isClosed()) {
                    consumer.accept(this.jedisPool.getResource());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        };
        if (async) {
            this.plugin.getScheduler().runAsync(wrappedTask -> runnable.run());
        } else {
            runnable.run();
        }
    }
}

