/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.hooks.redis;

import com.google.gson.Gson;
import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.hooks.redis.RedisListener;
import fr.maxlego08.essentials.hooks.redis.RedisMessage;
import fr.maxlego08.essentials.hooks.redis.RedisServer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;

public class RedisSubscriberRunnable
implements Runnable {
    public static final String messagesChannel = "essentials:messages";
    private final EssentialsPlugin plugin;
    private final RedisServer server;
    private final Map<Class<?>, RedisListener<?>> listeners = new HashMap();

    public RedisSubscriberRunnable(EssentialsPlugin plugin, RedisServer server) {
        this.plugin = plugin;
        this.server = server;
    }

    public <T> void registerListener(Class<T> messageClass, RedisListener<T> listener) {
        this.listeners.put(messageClass, listener);
    }

    private RedisListener<?> getListener(Class<?> messageClass) {
        return this.listeners.get(messageClass);
    }

    @Override
    public void run() {
        try (Jedis jedis = this.server.getJedisPool().getResource();){
            final Gson gson = this.plugin.getGson();
            JedisPubSub jedisPubSub = new JedisPubSub(){

                @Override
                public void onMessage(String channel, String message) {
                    RedisSubscriberRunnable.this.plugin.debug("Receive: " + message + " from " + channel);
                    if (!Objects.equals(channel, RedisSubscriberRunnable.messagesChannel)) {
                        return;
                    }
                    RedisMessage redisMessage = (RedisMessage)gson.fromJson(message, RedisMessage.class);
                    if (redisMessage == null) {
                        RedisSubscriberRunnable.this.plugin.getLogger().severe("Server instance not found ! Message: " + message);
                        return;
                    }
                    if (redisMessage.serverId().equals(RedisSubscriberRunnable.this.server.getInstanceId())) {
                        return;
                    }
                    Map map = (Map)redisMessage.t();
                    RedisSubscriberRunnable.this.plugin.debug("Map: " + String.valueOf(map));
                    try {
                        Class<?> messageClass = Class.forName(redisMessage.className());
                        RedisListener<?> listener = RedisSubscriberRunnable.this.getListener(messageClass);
                        Object result = RedisSubscriberRunnable.this.plugin.getUtils().createInstanceFromMap(messageClass.getConstructors()[0], map);
                        RedisSubscriberRunnable.this.plugin.debug("MessageClass: " + String.valueOf(messageClass));
                        RedisSubscriberRunnable.this.plugin.debug("Listener: " + String.valueOf(listener));
                        RedisSubscriberRunnable.this.plugin.debug("Result: " + String.valueOf(result));
                        if (listener != null) {
                            listener.message(result);
                        }
                    }
                    catch (ClassNotFoundException exception) {
                        exception.printStackTrace();
                    }
                }
            };
            jedis.subscribe(jedisPubSub, messagesChannel);
        }
        catch (Exception exception) {
            this.plugin.getLogger().severe("Failed to subscribe: " + exception.getMessage());
        }
    }
}

