/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.libs.sarah.requests;

import fr.maxlego08.essentials.libs.sarah.DatabaseConfiguration;
import fr.maxlego08.essentials.libs.sarah.DatabaseConnection;
import fr.maxlego08.essentials.libs.sarah.conditions.ColumnDefinition;
import fr.maxlego08.essentials.libs.sarah.database.DatabaseType;
import fr.maxlego08.essentials.libs.sarah.database.Executor;
import fr.maxlego08.essentials.libs.sarah.database.Schema;
import fr.maxlego08.essentials.libs.sarah.logger.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UpsertBatchRequest
implements Executor {
    private final List<Schema> schemas;

    public UpsertBatchRequest(List<Schema> schemas) {
        this.schemas = schemas;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(DatabaseConnection databaseConnection, DatabaseConfiguration databaseConfiguration, Logger logger) {
        if (this.schemas.isEmpty()) {
            return 0;
        }
        DatabaseType databaseType = databaseConfiguration.getDatabaseType();
        Schema firstSchema = this.schemas.get(0);
        StringBuilder insertQuery = new StringBuilder("INSERT INTO " + firstSchema.getTableName() + " (");
        StringBuilder valuesQuery = new StringBuilder("VALUES ");
        StringBuilder onUpdateQuery = new StringBuilder();
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<String> placeholders = new ArrayList<String>();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (ColumnDefinition column : firstSchema.getColumns()) {
            columnNames.add(column.getSafeName());
        }
        insertQuery.append(String.join((CharSequence)", ", columnNames)).append(") ");
        for (Schema schema : this.schemas) {
            ArrayList<String> rowPlaceholders = new ArrayList<String>();
            for (ColumnDefinition column : schema.getColumns()) {
                rowPlaceholders.add("?");
                values.add(column.getObject());
            }
            placeholders.add("(" + String.join((CharSequence)", ", rowPlaceholders) + ")");
        }
        valuesQuery.append(String.join((CharSequence)", ", placeholders));
        if (databaseType == DatabaseType.SQLITE) {
            StringBuilder onConflictQuery = new StringBuilder(" ON CONFLICT (");
            List<String> primaryKeys = firstSchema.getPrimaryKeys();
            onConflictQuery.append(String.join((CharSequence)", ", primaryKeys)).append(") DO UPDATE SET ");
            for (int i = 0; i < columnNames.size(); ++i) {
                if (i > 0) {
                    onUpdateQuery.append(", ");
                }
                onUpdateQuery.append((String)columnNames.get(i)).append(" = excluded.").append((String)columnNames.get(i));
            }
            insertQuery.append((CharSequence)valuesQuery).append((CharSequence)onConflictQuery).append((CharSequence)onUpdateQuery);
        } else {
            onUpdateQuery.append(" ON DUPLICATE KEY UPDATE ");
            for (int i = 0; i < columnNames.size(); ++i) {
                if (i > 0) {
                    onUpdateQuery.append(", ");
                }
                onUpdateQuery.append((String)columnNames.get(i)).append(" = VALUES(").append((String)columnNames.get(i)).append(")");
            }
            insertQuery.append((CharSequence)valuesQuery).append((CharSequence)onUpdateQuery);
        }
        String finalQuery = databaseConfiguration.replacePrefix(insertQuery.toString());
        if (databaseConfiguration.isDebug()) {
            logger.info("Executing SQL: " + finalQuery);
        }
        try (Connection connection = databaseConnection.getConnection();){
            int n;
            block26: {
                PreparedStatement preparedStatement = connection.prepareStatement(finalQuery);
                try {
                    int index = 1;
                    for (Object e : values) {
                        preparedStatement.setObject(index++, e);
                    }
                    n = preparedStatement.executeUpdate();
                    if (preparedStatement == null) break block26;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return n;
        }
        catch (SQLException exception) {
            exception.printStackTrace();
            return -1;
        }
    }
}

