/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.module;

import fr.maxlego08.essentials.ZEssentialsPlugin;
import fr.maxlego08.essentials.api.event.UserEvent;
import fr.maxlego08.essentials.api.event.events.economy.EconomyBaltopUpdateEvent;
import fr.maxlego08.essentials.api.modules.Module;
import fr.maxlego08.essentials.api.storage.IStorage;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.zutils.utils.YamlLoader;
import fr.maxlego08.menu.api.InventoryManager;
import fr.maxlego08.menu.api.exceptions.InventoryException;
import fr.maxlego08.menu.api.pattern.PatternManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public abstract class ZModule
extends YamlLoader
implements Module {
    protected final ZEssentialsPlugin plugin;
    protected final String name;
    protected boolean isEnable = false;
    protected boolean isRegisterEvent = true;
    protected boolean copyAndUpdate = true;

    public ZModule(ZEssentialsPlugin plugin, String name) {
        this.plugin = plugin;
        this.name = name;
    }

    @Override
    public void loadConfiguration() {
        File folder = this.getFolder();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (this.copyAndUpdate) {
            this.plugin.saveOrUpdateConfiguration("modules/" + this.name + "/config.yml", true);
        } else {
            File file = new File(this.getFolder(), "config.yml");
            if (!file.exists()) {
                this.plugin.saveResource("modules/" + this.name + "/config.yml", false);
            }
        }
        YamlConfiguration configuration = this.getConfiguration();
        this.loadYamlConfirmation(this.plugin, configuration);
        this.isEnable = configuration.getBoolean("enable", true);
    }

    @Override
    public boolean isRegisterEvent() {
        return this.isRegisterEvent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public File getFolder() {
        return new File(this.plugin.getDataFolder(), "modules/" + this.name);
    }

    @Override
    public YamlConfiguration getConfiguration() {
        return YamlConfiguration.loadConfiguration((File)this.getConfigurationFile());
    }

    @Override
    public File getConfigurationFile() {
        return new File(this.getFolder(), "config.yml");
    }

    @Override
    public boolean isEnable() {
        return this.isEnable;
    }

    protected void loadInventory(String inventoryName) {
        InventoryManager inventoryManager = this.plugin.getInventoryManager();
        try {
            inventoryManager.loadInventoryOrSaveResource((Plugin)this.plugin, "modules/" + this.name + "/" + inventoryName + ".yml");
        }
        catch (InventoryException exception) {
            exception.printStackTrace();
        }
    }

    protected void loadPattern(String patternName) {
        PatternManager patternManager = this.plugin.getPatternManager();
        File file = new File(this.plugin.getDataFolder(), "patterns/" + patternName + ".yml");
        if (!file.exists()) {
            this.plugin.saveResource("patterns/" + patternName + ".yml", false);
        }
        try {
            patternManager.loadPattern(file);
        }
        catch (InventoryException exception) {
            exception.printStackTrace();
        }
    }

    protected void savePattern(String patternName) {
        File file = new File(this.plugin.getDataFolder(), "patterns/" + patternName + ".yml");
        if (!file.exists()) {
            this.plugin.saveResource("patterns/" + patternName + ".yml", false);
        }
    }

    protected User getUser(Entity entity) {
        return this.plugin.getStorageManager().getStorage().getUser(entity.getUniqueId());
    }

    protected User getUser(UUID uuid) {
        return this.plugin.getStorageManager().getStorage().getUser(uuid);
    }

    protected boolean isPaperVersion() {
        try {
            Class.forName("net.kyori.adventure.text.Component");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean isCopyAndUpdate() {
        return this.copyAndUpdate;
    }

    protected void registerEvents(List<String> events) {
        PluginManager pluginManager = Bukkit.getServer().getPluginManager();
        events.forEach(eventName -> {
            try {
                Class<?> eventClass = Class.forName(eventName);
                if (!Event.class.isAssignableFrom(eventClass)) {
                    this.plugin.getLogger().severe("Class " + eventName + " is not an event !");
                    return;
                }
                pluginManager.registerEvent(eventClass.asSubclass(Event.class), (Listener)this, EventPriority.NORMAL, (listener, event) -> this.updateLineWithEvent((String)eventName, event), (Plugin)this.plugin);
            }
            catch (ClassNotFoundException exception) {
                this.plugin.getLogger().severe("Class " + eventName + " was not found !");
                exception.printStackTrace();
            }
        });
    }

    private void updateLineWithEvent(String eventName, Event event) {
        if (!event.getClass().getName().equals(eventName)) {
            return;
        }
        if (event instanceof PlayerEvent) {
            PlayerEvent playerEvent = (PlayerEvent)event;
            this.updateEventPlayer(playerEvent.getPlayer(), eventName);
        } else if (event instanceof BlockBreakEvent) {
            BlockBreakEvent playerEvent = (BlockBreakEvent)event;
            this.updateEventPlayer(playerEvent.getPlayer(), eventName);
        } else if (event instanceof BlockPlaceEvent) {
            BlockPlaceEvent playerEvent = (BlockPlaceEvent)event;
            this.updateEventPlayer(playerEvent.getPlayer(), eventName);
        } else if (event instanceof UserEvent) {
            UserEvent userEvent = (UserEvent)event;
            UUID uuid = userEvent.getUser().getUniqueId();
            this.updateEventUniqueId(uuid, eventName);
        } else if (event instanceof EconomyBaltopUpdateEvent) {
            this.updateEvent(eventName);
        } else {
            this.plugin.getLogger().severe("Event : " + event.getClass().getName() + " is not a Player or User event ! You cant use it");
        }
    }

    protected void updateEventPlayer(Player player, String eventName) {
    }

    protected void updateEventUniqueId(UUID uniqueId, String eventName) {
    }

    protected void updateEvent(String eventName) {
        Bukkit.getOnlinePlayers().forEach(player -> this.updateEventPlayer((Player)player, eventName));
    }

    protected <T> T or(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    protected IStorage getStorage() {
        return this.plugin.getStorageManager().getStorage();
    }

    protected void files(File folder, Consumer<File> consumer) {
        try (Stream<Path> stream = Files.walk(Paths.get(folder.getPath(), new String[0]), new FileVisitOption[0]);){
            stream.skip(1L).map(Path::toFile).filter(File::isFile).filter(e -> e.getName().endsWith(".yml")).forEach(consumer);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

